<?php
use Cake\Routing\Route\DashedRoute;
use Cake\Routing\RouteBuilder;

return function (RouteBuilder $routes): void {
    $routes->setRouteClass(DashedRoute::class);

    $routes->scope('/', function (RouteBuilder $builder): void {
        // Homepage route
        $builder->connect('/', ['controller' => 'Pages', 'action' => 'display', 'home']);

        // Pages controller default display route
        $builder->connect('/pages/*', 'Pages::display');

        // 🔐 Auth routes
        $builder->connect('/register', ['controller' => 'Auth', 'action' => 'register']);
        $builder->connect('/forgot-password', ['controller' => 'Auth', 'action' => 'forgotPassword']);
        $builder->connect('/reset-password/*', ['controller' => 'Auth', 'action' => 'resetPassword']);
        $builder->connect('/auth/test-email', ['controller' => 'Auth', 'action' => 'testEmail']);

        // Fallbacks for all other controller/action routes
        $builder->fallbacks();
    });
    
    // Stripe related routes
    $routes->connect('/stripe/checkout', ['controller' => 'Stripe', 'action' => 'checkout']);
    $routes->connect('/stripe/create-session', ['controller' => 'Stripe', 'action' => 'createSession']);
    $routes->connect('/stripe/success', ['controller' => 'Stripe', 'action' => 'success']);
    $routes->connect('/stripe/cancel', ['controller' => 'Stripe', 'action' => 'cancel']);
    $routes->connect('/stripe/webhook', ['controller' => 'Stripe', 'action' => 'webhook']);
    
    // Payments related routes
    $routes->connect('/payments/success', ['controller' => 'Payments', 'action' => 'success']);
    $routes->connect('/payments/cancel', ['controller' => 'Payments', 'action' => 'cancel']);
    
    $routes->connect('/admin/dashboard', ['controller' => 'Admin', 'action' => 'dashboard']);

    /*
     * Example API scope (if needed)
     *
     * $routes->scope('/api', function (RouteBuilder $builder): void {
     *     $builder->setExtensions(['json', 'xml']);
     *     // API-specific routes go here.
     * });
     */
};
