<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Application Controller
 * Handles initialization, error handling, and missing actions
 */

namespace App\Controller;

use Cake\Controller\Controller;
use Cake\Http\Exception\NotFoundException;

class AppController extends Controller
{
    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * @return void
     */
    public function initialize(): void
    {
        parent::initialize();

        $this->loadComponent('Flash');
        // Enable the following component for CakePHP form protection settings
        // see https://book.cakephp.org/5/en/controllers/components/form-protection.html
        // $this->loadComponent('FormProtection');
    }

    /**
     * Catch-all handler for missing actions: throw a 404 Not Found.
     *
     * This will handle undefined actions and display a friendly error page.
     *
     * @param string $method The missing method name
     * @param array $args The arguments passed
     * @throws \Cake\Http\Exception\NotFoundException
     * @return void
     */
    public function __call(string $method, array $args)
    {
        // Log missing action for debugging purposes
        $this->log("Missing action: {$method}", 'error');

        // Throw NotFoundException with a user-friendly message
        throw new NotFoundException(__('Page not found'));
    }
}
