<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Purchase Entity
 *
 * @property int $id
 * @property int|null $user_id
 * @property string $name
 * @property string $email
 * @property string $phone_number
 * @property string $address_line1
 * @property string|null $address_line2
 * @property string $suburb
 * @property string $state
 * @property string $postcode
 * @property \Cake\I18n\DateTime|null $purchase_date
 * @property string $total_price
 * @property string|null $status
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\User $user
 * @property \App\Model\Entity\Payment[] $payments
 * @property \App\Model\Entity\ProductPurchase[] $product_purchase
 */
class Purchase extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'user_id' => true,
        'first_name' => true,
        'last_name' => true,
        'email' => true,
        'phone_number' => true,
        'address_line1' => true,
        'address_line2' => true,
        'suburb' => true,
        'state' => true,
        'postcode' => true,
        'purchase_date' => true,
        'total_price' => true,
        'status' => true,
        'created' => true,
        'modified' => true,
        'user' => true,
        'payments' => true,
        'product_purchase' => true,
    ];
}
