<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

class User extends Entity
{
    // Make first_name and last_name accessible but not required
    protected array $_accessible = [
        'email'            => true,
        'password'         => true,
        'password_confirm' => true,
        'nonce'            => true,
        'nonce_expiry'     => true,
        'created'          => true,
        'modified'         => true,
        'is_admin'         => true,
        'first_name'       => true,  // Allow first_name but don't make it required
        'last_name'        => true,  // Allow last_name but don't make it required
    ];

    // Hide the password field when converting to JSON or arrays
    protected array $_hidden = ['password'];

    /**
     * Automatically hash passwords on set.
     *
     * @param string $password The plain‐text password.
     * @return string|null The hashed password, or null if empty.
     */
    protected function _setPassword(string $password): ?string
    {
        if (strlen($password) > 0) {
            return password_hash($password, PASSWORD_DEFAULT);
        }
        return null;
    }
}
