<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Ratings Model
 *
 * @property \App\Model\Table\ProductsTable&\Cake\ORM\Association\BelongsTo $Products
 *
 * @method \App\Model\Entity\Rating newEmptyEntity()
 * @method \App\Model\Entity\Rating newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Rating> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Rating get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Rating findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Rating patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Rating> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Rating|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Rating saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Rating>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Rating>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Rating>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Rating> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Rating>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Rating>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Rating>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Rating> deleteManyOrFail(iterable $entities, array $options = [])
 */
class RatingsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('ratings');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Product', [
            'foreignKey' => 'product_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('rating')
            ->allowEmptyString('rating');

        $validator
            ->integer('product_id')
            ->allowEmptyString('product_id');

        $validator
            ->scalar('review')
            ->allowEmptyString('review');
            

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['product_id'], 'Product'), ['errorField' => 'product_id']);

        return $rules;
    }
}
