<?php $this->assign('title', 'Admin Dashboard'); ?>

<style>
    body {
        margin: 0;
        padding: 0;
        background-color: #121212;
        font-family: 'Montserrat', sans-serif;
        color: #e0e0e0;
    }

    h1 {
        font-size: 3rem;
        text-align: center;
        margin: 60px 0 40px;
        color: #ffffff;
        position: relative;
        letter-spacing: 1px;
    }

    h1::after {
        content: '';
        display: block;
        margin: 18px auto 0;
        width: 120px;
        height: 4px;
        background-color: #ff4d4d;
    }

    .dashboard-container {
        max-width: 1200px;
        margin: 0 auto;
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 40px;
        padding: 0 30px 80px;
    }

    .dashboard-link {
        text-decoration: none;
        color: inherit;
    }

    .dashboard-card {
        background-color: #1f1f1f;
        border: 1px solid #333;
        border-radius: 12px;
        padding: 35px 25px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.25);
        text-align: center;
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .dashboard-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 30px rgba(255, 77, 77, 0.3);
    }

    .dashboard-card p.label {
        font-size: 1.1rem;
        color: #bbbbbb;
        margin-bottom: 1rem;
        letter-spacing: 0.8px;
    }

    .dashboard-card p.value {
        font-size: 2.5rem;
        font-weight: bold;
        color: #ff4d4d;
    }

    @media (max-width: 700px) {
        h1 {
            font-size: 2.5rem;
        }

        .dashboard-container {
            grid-template-columns: 1fr;
            gap: 20px;
        }
    }
</style>

<body>
    <h1>Admin Dashboard</h1>

    <div class="dashboard-container">
        <a href="<?= $this->Url->build('/product') ?>" class="dashboard-link">
            <div class="dashboard-card">
                <p class="label">Total Products</p>
                <p class="value"><?= $productCount ?? '0' ?></p>
            </div>
        </a>

        <a href="<?= $this->Url->build('/purchases') ?>" class="dashboard-link">
            <div class="dashboard-card">
                <p class="label">Total Purchases</p>
                <p class="value"><?= $purchaseCount ?? '0' ?></p>
            </div>
        </a>

        <a href="<?= $this->Url->build('/contact-form') ?>" class="dashboard-link">
            <div class="dashboard-card">
                <p class="label">Non-Replied Contact Forms</p>
                <p class="value"><?= $nonRepliedCount ?? '0' ?></p>
            </div>
        </a>
        
    </div>
    
    <a href="<?= $this->Url->build(['plugin' => 'ContentBlocks', 'controller' => 'ContentBlocks', 'action' => 'index']) ?>" class="dashboard-link">
        <div class="dashboard-card">
            <p class="label">Manage Website</p>
            <p class="value">Go &rarr;</p>
        </div>
    </a>


</body>
