<?php
$this->assign('title', 'Admin Login - PowerPro Shop');
?>

<style>
    body {
        font-family: 'Montserrat', sans-serif;
        background-image: url('/img/products/loginbackground.png');
        background-repeat: no-repeat;
        background-size: cover;
        background-position: center center;
        background-attachment: scroll;
        background-color: #000;
        color: #fff;
    }

    .background-slideshow {
        position: fixed;
        top: 0;
        left: 0;
        height: 100vh;
        width: 100%;
        z-index: -1;
        overflow: hidden;
    }

    .background-slideshow img {
        position: absolute;
        width: 100%;
        height: 100%;
        object-fit: cover;
        opacity: 0;
        animation: fadeSlideshow 12s infinite;
    }

    .background-slideshow img:nth-child(1) {
        animation-delay: 0s;
    }

    .background-slideshow img:nth-child(2) {
        animation-delay: 6s;
    }

    @keyframes fadeSlideshow {
        0% { opacity: 0; }
        10% { opacity: 1; }
        45% { opacity: 1; }
        55% { opacity: 0; }
        100% { opacity: 0; }
    }

    .custom-login-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        position: relative;
        z-index: 1;
    }

    .custom-login-box {
        max-width: 400px;
        width: 100%;
        background-color: rgba(255, 255, 255, 1);
        padding: 40px 30px 50px;
        border-radius: 20px;
        box-shadow: 0 0 30px rgba(0, 0, 0, 0.3);
    }

    .custom-login-box h2 {
        font-weight: bold;
        font-size: 28px;
        margin-bottom: 25px;
        text-align: left;
        color: #000;
    }

    .custom-login-box label {
        font-weight: 500;
        margin-top: 10px;
        display: block;
        color: #000;
    }

    .custom-login-box input[type="text"],
    .custom-login-box input[type="email"],
    .custom-login-box input[type="password"] {
        width: 100%;
        padding: 12px;
        margin-top: 6px;
        border: 1px solid #ccc;
        border-radius: 4px;
        font-size: 16px;
    }

    .custom-login-box .btn-login {
        width: 100%;
        background-color: #1c1c1c;
        color: white;
        border: none;
        padding: 24px;
        font-size: 18px;
        font-weight: bold;
        margin-top: 20px;
        cursor: pointer;
        border-radius: 4px;
        text-align: center;
        line-height: 0.1;
    }

    .custom-login-box .btn-login:hover {
        background-color: #333;
    }

    .forgot-password-link,
    .register-link {
        display: block;
        margin-top: 15px;
        text-align: center;
        font-size: 14px;
        color: #007bff;
        text-decoration: none;
    }

    .forgot-password-link:hover,
    .register-link:hover {
        text-decoration: underline;
    }

    .flash-message {
        margin-top: 20px;
        text-align: center;
        color: red;
    }
</style>

<div class="background-slideshow">
    <img src="./webroot/img/dumbell.png" alt="Fitness Equipment 1">
    <img src="./webroot/img/treadmill.png" alt="Fitness Equipment 2">
</div>

<div class="custom-login-wrapper">
    <div class="custom-login-box">
        <h2>Admin Log In</h2>

        <div class="flash-message">
            <?= $this->Flash->render() ?>
        </div>

        <?= $this->Form->create(null, ['autocomplete' => 'off']) ?>

        <?= $this->Form->control('email', [
            'label' => 'Email',
            'required' => true,
            'type' => 'email',
            'templates' => ['inputContainer' => '{{content}}'],
        ]) ?>

        <?= $this->Form->control('password', [
            'label' => 'Password',
            'required' => true,
            'type' => 'password',
            'templates' => ['inputContainer' => '{{content}}'],
        ]) ?>

        <div style="margin: 20px 0;">
            <?= $this->Recaptcha->display() ?>
        </div>

        <?= $this->Form->button('Log In', ['class' => 'btn-login']) ?>
        <?= $this->Form->end() ?>

        <!-- 🔒 Forgot Password -->
        <?= $this->Html->link('Forgot your password?', ['controller' => 'Auth', 'action' => 'forgotPassword'], ['class' => 'forgot-password-link']) ?>

    </div>
</div>

<?= $this->Html->script('https://www.google.com/recaptcha/api.js') ?>
