<h2 style="display: none;">Register</h2>

<style>
    body {
        font-family: 'Montserrat', sans-serif;
        background-color: #1e1e1e;
        color: #fff;
    }

    .register-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 60px 20px;
        min-height: 90vh;
    }

    .register-box {
        max-width: 450px;
        width: 100%;
        background-color: #2a2a2a;
        padding: 40px;
        border-radius: 12px;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
    }

    .register-box h2 {
        text-align: center;
        color: #fff;
        margin-bottom: 25px;
        font-weight: 600;
    }

    .form-label {
        display: block;
        margin-bottom: 6px;
        font-weight: 500;
        color: #ddd;
    }

    input[type="text"],
    input[type="email"],
    input[type="password"] {
        width: 100%;
        padding: 12px 14px;
        margin-bottom: 20px;
        border: 1px solid #444;
        border-radius: 6px;
        background-color: #fff;
        color: #000;
        font-size: 15px;
    }

    .register-btn {
        width: 100%;
        padding: 18px;
        background-color: #ff4d4d;
        color: white;
        font-weight: bold;
        border: none;
        border-radius: 6px;
        font-size: 14px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .register-btn:hover {
        background-color: #e84141;
    }

    .flash-message {
        text-align: center;
        color: #ff8080;
        margin-bottom: 15px;
    }
</style>

<div class="register-wrapper">
    <div class="register-box">
        <h2>Create Account</h2>

        <div class="flash-message">
            <?= $this->Flash->render() ?>
        </div>

        <?= $this->Form->create($user) ?>

        <!-- Email Field -->
        <label for="email" class="form-label">Email</label>
        <?= $this->Form->control('email', ['label' => false, 'type' => 'email', 'required' => true]) ?>

        <!-- Password Field -->
        <label for="password" class="form-label">Password</label>
        <?= $this->Form->control('password', ['label' => false, 'type' => 'password', 'required' => true]) ?>

        <!-- Confirm Password Field -->
        <label for="password_confirm" class="form-label">Confirm Password</label>
        <?= $this->Form->control('password_confirm', ['label' => false, 'type' => 'password', 'required' => true]) ?>

        <!-- Submit Button -->
        <?= $this->Form->button('Register', ['class' => 'register-btn']) ?>
        <?= $this->Form->end() ?>
    </div>
</div>
