<?php
$this->assign('title', 'Reset Password');
?>

<style>
    body {
        font-family: 'Montserrat', sans-serif;
        background-color: #1e1e1e;
        color: #fff;
        margin: 0;
    }

    .reset-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 60px 20px;
        min-height: 90vh;
    }

    .reset-box {
        max-width: 450px;
        width: 100%;
        background-color: #2a2a2a;
        padding: 40px;
        border-radius: 12px;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
    }

    .reset-box h2 {
        text-align: center;
        color: #fff;
        margin-bottom: 25px;
        font-weight: 600;
    }

    .form-label {
        display: block;
        margin-bottom: 6px;
        font-weight: 500;
        color: #ddd;
    }

    input[type="password"] {
        width: 100%;
        padding: 12px 14px;
        margin-bottom: 20px;
        border: 1px solid #444;
        border-radius: 6px;
        background-color: #fff;
        color: #000;
        font-size: 15px;
    }

    .btn-reset {
        width: 100%;
        padding: 14px;
        background-color: #ff4d4d;
        color: white;
        font-weight: bold;
        border: none;
        border-radius: 6px;
        font-size: 16px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn-reset:hover {
        background-color: #e84141;
    }

    .flash-message {
        text-align: center;
        color: #ff8080;
        margin-bottom: 15px;
    }
</style>

<div class="reset-wrapper">
    <div class="reset-box">
        <h2>Reset Your Password</h2>

        <div class="flash-message">
            <?= $this->Flash->render() ?>
        </div>

        <?= $this->Form->create($user) ?>

        <label for="password" class="form-label">New Password</label>
        <?= $this->Form->control('password', [
            'type' => 'password',
            'label' => false,
        ]) ?>

        <label for="password_confirm" class="form-label">Confirm Password</label>
        <?= $this->Form->control('password_confirm', [
            'type' => 'password',
            'label' => false,
        ]) ?>

        <?= $this->Form->button('Update Password', ['class' => 'btn-reset']) ?>
        <?= $this->Form->end() ?>
    </div>
</div>
