<?php
declare(strict_types=1);

namespace App\Error;

use Cake\Error\ExceptionRendererInterface;
use Cake\Error\ExceptionRenderer;
use Cake\Controller\Exception\MissingActionException;
use Cake\Http\Exception\NotFoundException;

class AppExceptionRenderer extends ExceptionRenderer implements ExceptionRendererInterface
{
    /**
     * Convert any missing‐action error into a 404 Not Found.
     *
     * @param \Cake\Controller\Exception\MissingActionException $error
     * @return \Cake\Http\Response
     */
    public function missingAction(MissingActionException $error)
    {
        $notFound = new NotFoundException($error->getMessage(), null, $error);
        return $this->_outputMessage('error404', $notFound);
    }
}
