<?php
use Cake\Datasource\ConnectionManager;
use Cake\Core\Configure;
use Cake\Http\Exception\NotFoundException;

$this->disableAutoLayout();

$checkConnection = function (string $name) {
    $error = null;
    $connected = false;
    try {
        ConnectionManager::get($name)->getDriver()->connect();
        $connected = true;
    } catch (Exception $connectionError) {
        $error = $connectionError->getMessage();
        if (method_exists($connectionError, 'getAttributes')) {
            $attributes = $connectionError->getAttributes();
            if (isset($attributes['message'])) {
                $error .= '<br />' . $attributes['message'];
            }
        }
    }
    return compact('connected', 'error');
};

if (!Configure::read('debug')) {
    throw new NotFoundException('Page not available in production.');
}
?>

<?php if (isset($successMessage)): ?>
    <script type="text/javascript">
        alert("<?= h($successMessage) ?>");
    </script>
<?php endif; ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>PowerPro Shop - Premium Fitness Equipment</title>
    <?= $this->Html->meta('icon') ?>
    <?= $this->Html->css('home.css') ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        /* Additional inline styles to complement home.css */
        
        /* Navbar */
        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #1f1f1f;
            padding: 20px 50px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
    
        .navbar a {
            color: #fff;
            text-decoration: none;
            margin-left: 30px;
            font-weight: 500;
            transition: color 0.3s;
            font-size: 16px;
        }
    
        .navbar a:hover {
            color: #ff4d4d;
            text-decoration: none;
        }
    
        .brand {
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 1px;
            margin-left: 30px;
        }
        
        .brand-text {
            font-size: 24px;
            font-weight: 700;
            color: #fff;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .brand-text:hover {
            color: #ff4d4d;
        }
    
        .login-btn {
            border: 1px solid #ff4d4d;
            padding: 8px 15px;
            border-radius: 4px;
            color: #ffffff;
            transition: background-color 0.3s, color 0.3s;
        }
    
        .login-btn:hover {
            background-color: #ff4d4d;
            color: #fff;
        }
        
        /* Mobile menu styles */
        .mobile-menu-icon {
            display: none;
            font-size: 24px;
            cursor: pointer;
        }
        
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: -100%;
            width: 80%;
            height: 100%;
            background-color: #1f1f1f;
            z-index: 999;
            padding: 50px 30px;
            transition: left 0.3s ease;
        }
        
        .mobile-menu.active {
            left: 0;
        }
        
        .mobile-menu-close {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 24px;
            cursor: pointer;
        }
        
        .mobile-menu a {
            display: block;
            margin: 20px 0;
            font-size: 18px;
        }
        
        /* Hero section overlay */
        .hero-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, rgba(18,18,18,1) 0%, rgba(18,18,18,0.8) 50%, rgba(18,18,18,0.4) 100%);
            z-index: 1;
        }
        
        /* Featured products section */
        .featured-products {
            padding: 60px 50px;
            background-color: #2b2b2b;
        }
        
        .section-title {
            font-size: 32px;
            margin-bottom: 40px;
            text-align: center;
            position: relative;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: #ff4d4d;
        }
        
        .product-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 30px;
        }
        
        .product-card {
            background-color: #1a1a1a;
            border-radius: 8px;
            overflow: hidden;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.3);
        }
        
        .product-image {
            height: 200px;
            overflow: hidden;
        }
        
        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .product-card:hover .product-image img {
            transform: scale(1.05);
        }
        
        .product-info {
            padding: 20px;
        }
        
        .product-name {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .product-price {
            color: #ff4d4d;
            font-weight: 700;
            font-size: 20px;
            margin-bottom: 15px;
        }
        
        .view-btn {
            background-color: transparent;
            border: 2px solid #ff4d4d;
            color: #ff4d4d;
            padding: 8px 16px;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .view-btn:hover {
            background-color: #ff4d4d;
            color: #fff;
        }
        
        /* View More Products Button */
        .view-more-container {
            text-align: center;
            margin-top: 40px;
        }
        
        .view-more-btn {
            background-color: #ff4d4d;
            color: #fff;
            padding: 12px 30px;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: background-color 0.3s, transform 0.3s;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 16px;
            border: none;
        }
        
        .view-more-btn:hover {
            background-color: #e53e3e;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(255, 77, 77, 0.3);
        }
        
        /* Why Choose Us Section */
        .why-choose {
            padding: 60px 50px;
            background-color: #121212;
        }
        
        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .feature-card {
            background-color: #1a1a1a;
            padding: 30px;
            border-radius: 8px;
            text-align: center;
            transition: transform 0.3s;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
        }
        
        .feature-icon {
            font-size: 40px;
            color: #ff4d4d;
            margin-bottom: 20px;
        }
        
        .feature-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        /* Newsletter Section */
        .newsletter {
            padding: 60px 50px;
            background-color: #1a1a1a;
            text-align: center;
        }
        
        .newsletter-form {
            max-width: 600px;
            margin: 30px auto 0;
            display: flex;
        }
        
        .newsletter-input {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: 4px 0 0 4px;
            font-size: 16px;
        }
        
        .newsletter-btn {
            background-color: #ff4d4d;
            color: #fff;
            border: none;
            padding: 15px 25px;
            border-radius: 0 4px 4px 0;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .newsletter-btn:hover {
            background-color: #e53e3e;
        }
        
        /* Responsive adjustments */
        @media screen and (max-width: 991px) {
            .content-container {
                flex-direction: column;
                height: auto;
                padding: 50px;
            }
            
            .content {
                margin-bottom: 40px;
                text-align: center;
            }
            
            .image-boxes {
                width: 100%;
                height: 500px;
            }
            
            .box1, .box2 {
                width: 300px;
                height: 250px;
            }
            
            .box1 {
                left: 50%;
                transform: translateX(-90%);
            }
            
            .box2 {
                left: 50%;
                transform: translateX(-10%);
            }
        }
        
        @media screen and (max-width: 768px) {
            .navbar {
                padding: 20px;
            }
            
            .links {
                display: none;
            }
            
            .mobile-menu-icon {
                display: block;
            }
            
            .mobile-menu {
                display: block;
            }
            
            .content-container {
                padding: 30px 20px;
            }
            
            .content h1 {
                font-size: 36px;
            }
            
            .image-boxes {
                height: 400px;
            }
            
            .box1, .box2 {
                width: 250px;
                height: 200px;
            }
            
            .box1 {
                transform: translateX(-100%);
            }
            
            .box2 {
                transform: translateX(0%);
            }
            
            .featured-products,
            .why-choose,
            .newsletter,
            .footer {
                padding: 40px 20px;
            }
            
            .product-grid,
            .features-grid {
                grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            }
            
            .newsletter-form {
                flex-direction: column;
            }
            
            .newsletter-input {
                border-radius: 4px;
                margin-bottom: 10px;
            }
            
            .newsletter-btn {
                border-radius: 4px;
            }
        }
        
        @media screen and (max-width: 480px) {
            .box1, .box2 {
                width: 200px;
                height: 160px;
            }
            
            .box1 {
                transform: translateX(-105%);
            }
            
            .box2 {
                transform: translateX(-5%);
            }
        }
    </style>
</head>
<body>
    
    <!-- Navigation Bar -->
    <div class="navbar">
        <div class="brand">
            <!-- Wrap the brand name with a clickable anchor tag but preserve the same style -->
            <a href="<?= $this->Url->build('/') ?>" style="text-decoration: none; color: inherit; font-family: 'Montserrat', sans-serif; font-weight: 700; font-size: 24px;">
                PowerPro Shop
            </a>
        </div>
        <div class="links">
            <a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>">Our Products</a>
            <a href="<?= $this->Url->build(['controller' => 'Service', 'action' => 'index']) ?>">Our Services</a>
            <a href="<?= $this->Url->build(['controller' => 'Faq', 'action' => 'faq']) ?>">FAQ</a>
            <a href="<?= $this->Url->build(['controller' => 'ContactForm', 'action' => 'add']) ?>">Contact Us</a> <!-- Desktop link -->
            <a href="<?= $this->Url->build(['controller' => 'Auth', 'action' => 'login']) ?>" class="login-btn" style="border: 1px solid #ff4d4d; padding: 8px 15px; border-radius: 4px; color: #ffffff;">Login</a>
            <?= $this->Html->link('<i class="fas fa-shopping-cart"></i>',
                ['controller' => 'Carts', 'action' => 'view'],
                ['class' => 'cart-link', 'escape' => false]
            ) ?>
        </div>
        <div class="mobile-menu-icon">
            <i class="fas fa-bars"></i>
        </div>
    </div>
    
    <!-- Mobile Menu -->
    <div class="mobile-menu">
        <div class="mobile-menu-close">
            <i class="fas fa-times"></i>
        </div>
        <a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>">Our Products</a>
        <a href="<?= $this->Url->build(['controller' => 'Service', 'action' => 'index']) ?>">Our Services</a>
        <a href="<?= $this->Url->build(['controller' => 'Faq', 'action' => 'faq']) ?>">FAQ</a>
        <a href="<?= $this->Url->build(['controller' => 'ContactForm', 'action' => 'add']) ?>">Contact Us</a> <!-- Added for mobile -->
        <a href="<?= $this->Url->build(['controller' => 'Auth', 'action' => 'login']) ?>">Login</a>
        <a href="<?= $this->Url->build(['controller' => 'Carts', 'action' => 'view']) ?>">
            <i class="fas fa-shopping-cart"></i> View Cart
        </a>
    </div>
    
    

    
    <!-- Hero Section -->
    <div class="content-container">
        <div class="hero-overlay"></div>
        <div class="content" style="z-index: 2;">
            <h1><?= $this->ContentBlock->text('website-title'); ?></h1>
            <p>
                <?= $this->ContentBlock->html('home-content'); ?>
            </p>
            <div class="buttons">
                <button onclick="location.href='<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>'">Explore Products</button>
            </div>
        </div>
        <div class="image-boxes" style="z-index: 2;">
            <div class="box1">
                <img src="<?= $this->Url->build('/img/products/dumbell.png') ?>" alt="Premium Weights">
            </div>
            <div class="box2">
                <img src="<?= $this->Url->build('/img/products/treadmill.png') ?>" alt="Advanced Treadmill">
            </div>
        </div>
    </div>
    
    <!-- Featured Products Section -->
    <div class="featured-products">
        <h2 class="section-title">Featured Products</h2>
        <div class="product-grid">
            <?php foreach ($product as $p): ?>
                <div class="product-card">
                    <div class="product-image" style="display: flex; justify-content: center; align-items: center;">
                        <img src="<?= $this->Url->build(h($p->image_url)) ?>" alt="<?= h($p->name) ?>"style="width: 320px; height: 250px; object-fit: cover;">
                    </div>
                    <div class="product-info">
                        <div class="product-name"><?= h($p->name) ?></div>
                        <div class="product-description"><?= h($p->description) ?></div>
                        <div class="product-price">$<?= number_format($p->price, 2) ?></div>
                        <a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'view', $p->id]) ?>" class="view-btn">View Details</a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <!-- View More Products Button -->
        <div class="view-more-container">
            <a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>" class="view-more-btn">View More Products</a>
        </div>
    </div>
    
    <!-- Why Choose Us Section -->
    <div class="why-choose">
        <h2 class="section-title">Why Choose PowerPro</h2>
        <div class="features-grid">
            <!-- Feature 1 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-medal"></i>
                </div>
                <h3 class="feature-title">Premium Quality</h3>
                <p>All our equipment is built to last, using high-grade materials and rigorous quality control standards.</p>
            </div>
            
            <!-- Feature 2 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-tools"></i>
                </div>
                <h3 class="feature-title">Expert Installation</h3>
                <p>Our professional team ensures your equipment is properly installed and safe to use from day one.</p>
            </div>
            
            <!-- Feature 3 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h3 class="feature-title">24/7 Support</h3>
                <p>Our customer service team is always available to answer questions and resolve any issues.</p>
            </div>
            
            <!-- Feature 4 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <h3 class="feature-title">5-Year Warranty</h3>
                <p>All PowerPro equipment comes with our industry-leading warranty for complete peace of mind.</p>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <div class="footer">
        <div class="footer-content">
            <!-- Column 1 -->
            <div class="footer-column">
                <h3>PowerPro Shop</h3>
                <p>Your premier destination for high-quality fitness equipment and expert services to help you achieve your fitness goals.</p>
            </div>
            
            <!-- Column 2 -->
            <div class="footer-column">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>">Products</a></li>
                    <li><a href="<?= $this->Url->build(['controller' => 'Service', 'action' => 'index']) ?>">Services</a></li>
                    <li><a href="<?= $this->Url->build(['controller' => 'ContactForm', 'action' => 'add']) ?>">Contact Us</a></li>
                </ul>
            </div>
            
            <!-- Column 3 -->
            <div class="footer-column">
                <h3>Payment Methods</h3>
                <ul>
                    <li><i class="fab fa-cc-visa"></i> Visa</li>
                    <li><i class="fab fa-cc-mastercard"></i> Mastercard</li>
                    <li><i class="fab fa-cc-amex"></i> American Express</li>
                    <li><i class="fab fa-cc-paypal"></i> PayPal</li>
                </ul>
            </div>
            
            <!-- Column 4 -->
            <div class="footer-column">
                <h3>Contact Info</h3>
                <ul>
                    <li><i class="fas fa-map-marker-alt"></i> 123 Fitness Street, Melbourne, Australia</li>
                    <li><i class="fas fa-phone"></i> <a href="tel:(03) 1234 5678">(03) 1234 5678</a></li>
                    <li><i class="fas fa-envelope"></i> <a href="mailto:info@powerproshop.com">info@powerproshop.com</a></li>
                    <li><i class="fas fa-clock"></i> Mon-Fri: 9am-6pm, Sat: 10am-4pm</li>
                </ul>
            </div>
        </div>
        
        <div class="copyright">
            &copy; <?= date('Y') ?> PowerPro Shop. All Rights Reserved.
        </div>
    </div>
    
    <script>
        // Mobile menu toggle
        document.querySelector('.mobile-menu-icon').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.add('active');
        });
        
        document.querySelector('.mobile-menu-close').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.remove('active');
        });
        
        // Add automatic image rotation animation to hero section if needed
        // This can be expanded based on requirements
    </script>
</body>
</html>