<?php
$user = $this->request->getSession()->read('Auth.User');
?>

<?php if (empty($user) || $user['is_admin'] != 1): ?>
    <script>
        window.onload = function() {
            document.getElementById('adminModal').style.display = 'block';
        };

        function closeModal() {
            document.getElementById('adminModal').style.display = 'none';
            window.location.href = '/';
        }
    </script>

    <div id="adminModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.85); z-index: 9999; color: white; padding-top: 100px; text-align: center;">
        <div style="background: #1f1f1f; padding: 40px; border-radius: 10px; width: 90%; max-width: 500px; margin: 0 auto; box-shadow: 0 5px 20px rgba(0,0,0,0.5);">
            <h2 style="font-size: 28px; color: #ff4d4d;">Admins Only</h2>
            <p style="font-size: 16px;">You do not have permission to access this page.</p>
            <button onclick="closeModal()" style="padding: 12px 25px; font-size: 16px; background-color: #ff4d4d; border: none; color: white; cursor: pointer; border-radius: 5px;">Close</button>
        </div>
    </div>
<?php else: ?>

    <div class="edit-product-section">
        <div class="edit-product-container">
            <button onclick="window.history.back();" class="back-btn">Back</button>

            <h2 class="edit-title">Edit Product Details</h2>

            <?php if (isset($product)): ?>
                <?= $this->Form->create($product, ['type' => 'file']) ?>
                    <div class="form-group">
                        <?= $this->Form->control('name', ['label' => 'Product Name', 'required' => true, 'class' => 'form-control']) ?>
                    </div>

                    <div class="form-group">
                        <?= $this->Form->control('description', [
                            'type' => 'textarea',
                            'label' => 'Description',
                            'required' => true,
                            'class' => 'form-control',
                            'rows' => 5
                        ]) ?>
                    </div>

                    <div class="form-group">
                        <?= $this->Form->control('price', ['label' => 'Price', 'type' => 'number', 'step' => '0.01', 'required' => true, 'class' => 'form-control']) ?>
                    </div>

                    <div class="form-group">
                        <?= $this->Form->control('stock', ['label' => 'Stock Quantity', 'type' => 'number', 'min' => 0, 'required' => true, 'class' => 'form-control']) ?>
                    </div>

                    <div class="form-group">
                        <?= $this->Form->control('image_file', ['label' => 'Product Image', 'type' => 'file', 'class' => 'form-control']) ?>
                    </div>

                    <div class="button-group">
                        <?= $this->Form->button(__('Update Product'), ['class' => 'btn primary-btn']) ?>
                        
                        <?= $this->Form->create(null, ['type' => 'post']) ?>
                        <?= $this->Form->end() ?>

                        <?= $this->Form->postLink(
                            __('Delete Product'),
                            ['action' => 'delete', $product->id],
                            [
                                'method' => 'post',
                                'confirm' => __('Are you sure you want to delete this product?'),
                                'class' => 'btn danger-btn'
                            ]) ?>
                    </div>
                <?= $this->Form->end() ?>
            <?php else: ?>
                <p style="color: #ddd;">No product found to edit.</p>
            <?php endif; ?>
        </div>
    </div>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap');

        body {
            font-family: 'Montserrat', sans-serif;
            background-color: #121212;
            color: #e0e0e0;
            margin: 0;
            padding: 0;
        }

        .edit-product-section {
            padding: 60px 30px;
        }

        .edit-product-container {
            background-color: #1a1a1a;
            max-width: 800px;
            margin: 0 auto;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.2);
            position: relative;
        }

        .back-btn {
            position: absolute;
            top: 20px;
            left: 20px;
            padding: 12px 25px;
            font-size: 16px;
            background-color: #333;
            border: none;
            color: white;
            cursor: pointer;
            border-radius: 5px;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .back-btn:hover {
            background-color: #444;
        }

        .edit-title {
            font-size: 28px;
            text-align: center;
            margin-bottom: 30px;
            position: relative;
            font-weight: 700;
            color: white;
        }

        .edit-title::after {
            content: '';
            position: absolute;
            width: 60px;
            height: 3px;
            background-color: #ff4d4d;
            bottom: -12px;
            left: 50%;
            transform: translateX(-50%);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-control[type="file"] {
            padding: 18px;
            font-size: 18px;
            height: auto;
        }

        .form-control {
            width: 100%;
            padding: 14px;
            border-radius: 5px;
            border: 1px solid #333;
            background-color: #2a2a2a;
            color: #fff;
            font-size: 16px;
            transition: border-color 0.3s, box-shadow 0.3s;
        }

        .form-control:focus {
            border-color: #ff4d4d;
            box-shadow: 0 0 6px rgba(255, 77, 77, 0.4);
            outline: none;
        }

        label {
            font-weight: 500;
            margin-bottom: 8px;
            display: block;
        }

        .button-group {
            display: flex;
            justify-content: flex-end;
            gap: 15px;
            margin-top: 30px;
        }

        .btn {
            border: none;
            border-radius: 5px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.2s;
        }

        .primary-btn {
            background-color: #ff4d4d;
            color: #fff;
            height: 60px;
            line-height: 60px;
            padding: 0 20px;
        }

        .primary-btn:hover {
            background-color: #ff6666;
        }

        .danger-btn {
            background-color: #e04a4a;
            color: #fff;
            height: 60px;
            line-height: 60px;
            padding: 0 20px;
        }

        .danger-btn:hover {
            background-color: #cc3a3a;
        }

        .btn:hover {
            transform: translateY(-2px);
        }

        @media (max-width: 768px) {
            .edit-product-section {
                padding: 30px 15px;
            }

            .edit-product-container {
                padding: 20px;
                box-shadow: none;
                width: 100%;
            }

            .back-btn {
                font-size: 14px;
                padding: 8px 18px;
                display: none;
            }

            .edit-title {
                font-size: 24px;
                margin-bottom: 20px;
            }

            .form-group {
                margin-bottom: 15px;
            }

            .form-control {
                font-size: 14px;
                padding: 12px;
            }

            .primary-btn, .danger-btn {
                width: 100%;
                height: 50px;
                font-size: 14px;
                line-height: 50px;
            }

            .button-group {
                flex-direction: column;
                align-items: center;
                gap: 10px;
            }
        }
    </style>

<?php endif; ?>
