<head>

    <style>
        * {
            box-sizing: border-box;
        }

        body {
            background-color: #121212;
            color: #ffffff;
            font-family: 'Montserrat', sans-serif;
            margin: 0;
            padding: 0;
        }

        .page-container {
            padding: 60px 20px 100px;
        }

        .purchases.form.content {
            background-color: #1e1e1e;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
            margin: 0 auto;
            max-width: 900px;
            position: relative;
        }

        legend {
            font-size: 28px;
            font-weight: 600;
            color: #fff;
            text-align: center;
            margin-bottom: 30px;
        }

        .form-columns {
            display: flex;
            gap: 30px;
            flex-wrap: wrap;
        }

        .form-column {
            flex: 1;
            min-width: 250px;
        }

        input[type="text"],
        input[type="email"],
        input[type="tel"],
        input[type="number"],
        select,
        textarea {
            width: 100%;
            padding: 12px;
            margin: 10px 0 20px;
            border: 1px solid #333;
            border-radius: 8px;
            font-size: 16px;
            background-color: #2a2a2a;
            color: #fff;
            transition: border-color 0.3s ease;
        }

        select {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg fill='white' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M7 10l5 5 5-5z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
            background-size: 18px;
            padding: 20px 12px;
            height: auto; 
            min-height: 60px; 
        }

        input:focus,
        select:focus,
        textarea:focus {
            border-color: #ff4d4d;
            outline: none;
        }

        label {
            color: #ccc;
            font-weight: 500;
            display: block;
            margin-bottom: 5px;
        }

        .form-button,
        button[type="submit"] {
            background-color: #ff4d4d;
            color: white;
            border: none;
            padding: 6px 24px;
            font-size: 16px;
            font-weight: bold;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            width: auto;
            min-width: 140px;
        }

        .form-button:hover,
        button[type="submit"]:hover {
            background-color: #e04343;
        }

        .total-price-display {
            position: absolute;
            bottom: 20px;
            left: 20px;
            text-align: left;
        }

        .total-price-display label {
            font-size: 22px;
            font-weight: bold;
        }

        .total-price-tag {
            background-color: #ff4d4d;
            color: #fff;
            font-size: 22px;
            font-weight: 600;
            padding: 10px 20px;
            border-radius: 8px;
            margin-top: 6px;
            display: inline-block;
        }

        .form-button-container {
            margin-top: 40px;
            bottom: 20px; 
            right: 20px;
            width: auto; 
            text-align: right;
        }

        @media screen and (max-width: 800px) {
            .form-columns {
                flex-direction: column;
            }

            .form-column {
                width: 100%;
            }

            .purchases.form.content {
                padding: 30px;
                margin-left: 10%;
                margin-right: auto;
            }

            .form-button-container,
            .total-price-display {
                position: static;
                text-align: center;
                margin-top: 20px;
            }

            .form-button-container {
                width: 100%;
            }

            .total-price-tag {
                font-size: 20px;
            }

            .back-button {
                display: none;
            }
        }

        @media screen and (min-width: 801px) {
            .back-button {
                position: absolute;
                top: 20px;
                left: 20px;
                background-color: #333;
                color: white;
                border: none;
                padding: 10px 20px;
                font-size: 16px;
                font-weight: bold;
                border-radius: 8px;
                cursor: pointer;
                transition: background-color 0.3s ease;
                display: flex;               /* Use flexbox for centering */
                justify-content: center;     /* Center text horizontally */
                align-items: center;         /* Center text vertically */
                width: auto;
                min-width: 140px;            /* Optional: to ensure it has a minimum width */
            }

            .back-button:hover {
                background-color: #444;
            }
        }

    </style>
</head>

<body>
    <div class="page-container">
        <div class="row">
            <div class="column column-100">
                <div class="purchases form content">
                    <button class="back-button" onclick="window.history.back();">Back</button>

                    <legend><?= __('Add Purchase') ?></legend>

                    <?= $this->Form->create($purchase, ['type' => 'post']) ?>
                    <fieldset>
                        <div class="form-columns">
                            <div class="form-column">
                                <?= $this->Form->control('first_name', [
                                    'label' => 'First Name *' // Change label text here
                                ]) ?>
                                <?= $this->Form->control('last_name', [
                                    'label' => 'Last Name *' // Change label text here
                                ]) ?>
                                <?= $this->Form->control('email', [
                                    'label' => 'Email Address *' // Change label text here
                                ]) ?>
                                <?= $this->Form->control('phone_number', [
                                    'label' => 'Phone Number *' // Change label text here
                                ]) ?>
                            </div>
                    
                            <div class="form-column">
                                <?= $this->Form->control('address_line1', [
                                    'label' => 'Address Line 1 *' // Change label text here
                                ]) ?>
                                <?= $this->Form->control('address_line2', [
                                    'label' => 'Address Line 2' // Change label text here
                                ]) ?>
                                <?= $this->Form->control('state', [
                                    'label' => 'State *', // Change label text here
                                    'type' => 'select',
                                    'options' => [
                                        'NSW' => 'New South Wales',
                                        'VIC' => 'Victoria',
                                        'QLD' => 'Queensland',
                                        'WA' => 'Western Australia',
                                        'SA' => 'South Australia',
                                        'TAS' => 'Tasmania',
                                        'ACT' => 'Australian Capital Territory',
                                        'NT' => 'Northern Territory'
                                    ],
                                    'empty' => 'Select a state'
                                ]) ?>
                                <?= $this->Form->control('suburb', [
                                    'label' => 'Suburb *' // Change label text here
                                ]) ?>
                                <?= $this->Form->control('postcode', [
                                    'label' => 'Postcode *' // Change label text here
                                ]) ?>
                            </div>
                        </div>
                    </fieldset>
                    
                    <div class="total-price-display">
                        <?= $this->Form->label('total_price', 'Total Price') ?><br>
                        <div class="total-price-tag">$<?= number_format($total ?? 0, 2) ?></div>
                        <?= $this->Form->hidden('total_price', ['value' => $total]) ?>
                    </div>
                    
                    <div class="form-button-container">
                        <?= $this->Form->button(__('Go to checkout')) ?>
                    </div>
                    <?= $this->Form->end() ?>

                </div>
            </div>
        </div>
    </div>
</body>
