<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Purchase> $purchases
 */

// Get the current logged-in user from the session
$user = $this->request->getSession()->read('Auth.User');

// If the user is not an admin, show the modal popup
if (empty($user) || $user['is_admin'] != 1): ?>
    <script>
        window.onload = function() {
            // Show the modal when the page loads
            document.getElementById('adminModal').style.display = 'block';
        };

        function closeModal() {
            document.getElementById('adminModal').style.display = 'none';
            // Redirect to homepage or another page after closing the modal
            window.location.href = '/';
        }
    </script>

    <!-- Modal Popup for non-admin users -->
    <div id="adminModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); z-index: 9999; color: white; padding-top: 100px; text-align: center;">
        <div style="background: #333; padding: 30px; border-radius: 10px; width: 50%; margin: 0 auto; box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.5);">
            <h2 style="font-size: 30px; color: #ff4d4d;">Admins Only</h2>
            <p style="font-size: 18px; color: #fff;">You do not have permission to access this page.</p>
            <button onclick="closeModal()" style="padding: 15px 25px; font-size: 18px; background-color: #ff4d4d; border: none; color: white; cursor: pointer; border-radius: 5px; box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.3);">Close</button>
        </div>
    </div>
<?php else: ?>
    <!-- If the user is an admin, show the Purchases list -->

    <div class="purchases index content">
        <h1 style="font-size: 40px; font-weight: 900; text-align: center; margin-bottom: 10px; color: #ff4d4d; font-family: 'Montserrat', sans-serif;">
            <?= __('Purchases') ?>
        </h1>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th><?= $this->Paginator->sort('first_name', 'Name') ?></th>
                        <th><?= $this->Paginator->sort('email') ?></th>
                        <th><?= $this->Paginator->sort('phone_number') ?></th>
                        <th><?= $this->Paginator->sort('address_line1','Address Line 1') ?></th>
                        <th><?= $this->Paginator->sort('address_line2', 'Address Line 2') ?></th>
                        <th><?= $this->Paginator->sort('suburb') ?></th>
                        <th><?= $this->Paginator->sort('state') ?></th>
                        <th><?= $this->Paginator->sort('postcode') ?></th>
                        <th><?= $this->Paginator->sort('purchase_date') ?></th>
                        <th><?= $this->Paginator->sort('total_price') ?></th>
                        <th><?= $this->Paginator->sort('status') ?></th>
                        <th class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($purchases as $purchase): ?>
                    <tr>
                        <td><?= h($purchase->first_name . ' ' . $purchase->last_name) ?></td>
                        <td><?= h($purchase->email) ?></td>
                        <td><?= h($purchase->phone_number) ?></td>
                        <td><?= h($purchase->address_line1) ?></td>
                        <td><?= h($purchase->address_line2) ?></td>
                        <td><?= h($purchase->suburb) ?></td>
                        <td><?= h($purchase->state) ?></td>
                        <td><?= h($purchase->postcode) ?></td>
                        <td><?= h($purchase->purchase_date) ?></td>
                        <td><?= $this->Number->format($purchase->total_price) ?></td>
                        <td><?= h($purchase->status) ?></td>
                        <td class="actions">
                            <div class="action-buttons">
                                <?= $this->Html->link(__('View'), ['action' => 'view', $purchase->id], ['class' => 'action-button view-button']) ?>
                                <?= $this->Html->link(__('Edit'), ['action' => 'edit', $purchase->id], ['class' => 'action-button edit-button']) ?>
                                <?= $this->Form->postLink(
                                    __('Delete'),
                                    ['action' => 'delete', $purchase->id],
                                    [
                                        'method' => 'delete',
                                        'confirm' => __('Are you sure you want to delete this?'),
                                        'class' => 'action-button delete-button'
                                    ]
                                ) ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="paginator">
            <ul class="pagination">
                <?= $this->Paginator->first('<< ' . __('first')) ?>
                <?= $this->Paginator->prev('< ' . __('previous')) ?>
                <?= $this->Paginator->numbers() ?>
                <?= $this->Paginator->next(__('next') . ' >') ?>
                <?= $this->Paginator->last(__('last') . ' >>') ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
        </div>
    </div>

<?php endif; ?>

<!-- Add custom styles to adjust the layout -->
<style>
    .purchases.index.content {
        background-color: #1f1f1f;
        color: #fff;
        padding: 20px;
    }

    h3 {
        color: #ff4d4d; /* Adjusted color for the heading */
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    th, td {
        padding: 12px 20px !important;
        text-align: left;
        border: 1px solid #ddd;
    }

    th {
        background-color: #333;
        color: white;
    }

    td {
        background-color: #444;
        color: white;
    }

    tr:hover {
        background-color: #555;
    }

    .actions {
        text-align: center;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        justify-content: center;
    }

    .action-button {
        padding: 8px 15px;
        text-decoration: none;
        border-radius: 4px;
        color: white;
        font-weight: bold;
    }

    .view-button {
        background-color: #4CAF50;
    }

    .view-button:hover {
        background-color: #45a049;
    }

    .edit-button {
        background-color: #FF4D4D;
    }

    .edit-button:hover {
        background-color: #ff3333;
    }

    .delete-button {
        background-color: #FF6A6A;
    }

    .delete-button:hover {
        background-color: #ff3333;
    }

    .paginator {
        text-align: center;
        padding-top: 20px;
    }

    .pagination {
        list-style: none;
        padding: 0;
    }

    .pagination li {
        display: inline;
        margin-right: 5px;
    }

    .pagination li a {
        color: #ff4d4d;
        text-decoration: none;
        font-weight: bold;
    }

    .pagination li a:hover {
        color: white;
        background-color: #ff4d4d;
        padding: 5px 10px;
        border-radius: 5px;
    }
</style>
