<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Service $service
 */
?>
<style>
    * {
        box-sizing: border-box;
        color: black;
    }

    .form-container {
        max-width: 500px;
        margin: 30px auto;
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 10px;
        background-color: #fff;
    }

    h3 {
        text-align: center;
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        margin-top: 10px;
    }

    input, textarea {
        width: 100%;
        padding: 10px;
        margin-bottom: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
    }

    .form-button {
        background-color: #dc3545;
        color: white;
        border: none;
        padding: 10px 15px;
        border-radius: 5px;
        cursor: pointer;
    }

    .form-button:hover {
        background-color: #a72828;
    }
</style>

<div class="form-container">
    <h3>Add New Service</h3>

    <?= $this->Form->create($service) ?>

    <?= $this->Form->control('name', ['label' => 'Service Name']) ?>

    <?= $this->Form->control('description', ['label' => 'Description', 'type' => 'textarea']) ?>

    <?= $this->Form->control('image_url', ['label' => 'Image URL']) ?>

    <?= $this->Form->button(__('Submit'), ['class' => 'form-button']) ?>

    <?= $this->Form->end() ?>
</div>

