<?php
/**
 * @var \App\View\AppView $this
 */
?>

<style>
    .admin-verify-container {
        max-width: 400px;
        margin: 50px auto;
        padding: 30px;
        background-color: #f8f9fa;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }

    .admin-verify-container h2 {
        text-align: center;
        margin-bottom: 20px;
        color: black;
    }

    .admin-verify-container label {
        color: black; /* <<< THIS makes the label black */
        font-weight: bold;
    }

    .admin-verify-container .form-group {
        margin-bottom: 20px;
    }

    .admin-verify-container input[type="password"] {
        color: black;
        background-color: white;
        border: 1px solid #ccc;
        padding: 10px;
        border-radius: 5px;
        width: 100%;
    }

    .admin-verify-container button {
        width: 100%;
        background-color: #007bff;
        color: white;
        border: none;
        padding: 10px;
        border-radius: 5px;
        cursor: pointer;
        font-weight: bold;
    }

    .admin-verify-container button:hover {
        background-color: #0056b3;
    }
</style>

<div class="admin-verify-container">
    <h2>Admin Access Required</h2>

    <?= $this->Form->create(null) ?>
        <div class="form-group">
            <?= $this->Form->control('password', [
                'type' => 'password',
                'label' => 'Admin Password',
                'required' => true
            ]) ?>
        </div>
        <?= $this->Form->button(__('Verify')) ?>
    <?= $this->Form->end() ?>
</div>
