<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\User> $users
 */
?>
<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        background-color: #fff;
        color: #333;
        border-radius: 8px;
        overflow: hidden;
    }

    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }

    th {
        background-color: #f4f4f4;
        color: #333;
        font-weight: bold;
    }

    tr:hover {
        background-color: #f9f9f9;
    }

    .actions a {
        margin-right: 10px;
        font-weight: bold;
        padding: 5px 10px;
        border-radius: 5px;
        text-decoration: none;
    }

    .actions a:first-child {
        color: #007bff; /* View - blue */
        background-color: #e6f2ff;
    }

    .actions a:nth-child(2) {
        color: #17a2b8; /* Edit - light blue */
        background-color: #e6f7ff;
    }

    .actions a:last-child {
        color: #dc3545; /* Delete - red */
        background-color: #ffe6e6;
    }

    .actions a:hover {
        opacity: 0.8;
    }

    .button.float-right {
        background-color: #28a745;
        color: white;
        padding: 10px 16px;
        border: none;
        border-radius: 6px;
        text-decoration: none;
        float: right;
        margin-bottom: 20px;
    }

    .button.float-right:hover {
        background-color: #218838;
    }

    .paginator {
        margin-top: 30px;
        text-align: center;
        color: #333;
    }

    .pagination li {
        display: inline-block;
        margin: 0 5px;
    }

    .pagination a {
        color: #007bff;
        text-decoration: none;
        padding: 5px 10px;
        border-radius: 5px;
        border: 1px solid #ddd;
    }

    .pagination a:hover {
        text-decoration: underline;
        background-color: #f1f1f1;
    }

    .pagination .active a {
        background-color: #007bff;
        color: white;
        border: none;
    }

</style>

<div class="users index content">
    <?= $this->Html->link(__('New User'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Users') ?></h3>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('email') ?></th>
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('modified') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= $this->Number->format($user->id) ?></td>
                        <td><?= h($user->email) ?></td>
                        <td><?= $this->Time->format($user->created, 'dd/MM/yyyy hh:mm:ss a') ?></td> <!-- Date format -->
                        <td><?= $this->Time->format($user->modified, 'dd/MM/yyyy hh:mm:ss a') ?></td> <!-- Date format -->
                        <td class="actions">
                            <?= $this->Html->link(__('View'), ['action' => 'view', $user->id], ['class' => 'btn-view']) ?>
                            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $user->id], ['class' => 'btn-edit']) ?>
                            <?= $this->Form->postLink(
                                __('Delete'),
                                ['action' => 'delete', $user->id],
                                [
                                    'method' => 'post',
                                    'confirm' => __('Are you sure you want to delete # {0}?', $user->id),
                                    'class' => 'btn-delete'
                                ]
                            ) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
