<?php
/**
 * @var \App\View\AppView $this
 */

$session = $this->request->getSession();
$user = $session->read('Auth.User');
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $this->fetch('title') ?></title>
    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->css(['normalize.min', 'milligram.min', 'fonts', 'cake']) ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
    
    <!--link to a certain css file in the webroot/css folder-->
    <?= $this->Html->css('footer') ?>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?= $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css') ?>
    <?= $this->Html->script('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js') ?>
    <?= $this->Html->css('https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css') ?>
    <?= $this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css') ?>
    <?= $this->Html->css('https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap') ?>

    <style>
        body {
            margin: 0;
            font-family: 'Montserrat', sans-serif;
            background-color: #2b2b2b;
            color: #ffffff;
            line-height: 1.6;
        }
    
        /* Navbar */
        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #1f1f1f;
            padding: 20px 50px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
    
        .navbar a {
            color: #fff;
            text-decoration: none;
            margin-left: 30px;
            font-weight: 500;
            transition: color 0.3s;
            font-size: 16px;
        }
    
        .navbar a:hover {
            color: #ff4d4d;
            text-decoration: none;
        }
    
        .brand {
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 1px;
            margin-left: 30px;
        }
        
        .brand-text {
            font-size: 24px;
            font-weight: 700;
            color: #fff;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .brand-text:hover {
            color: #ff4d4d;
        }
    
        .login-btn {
            border: 1px solid #ff4d4d;
            padding: 8px 15px;
            border-radius: 4px;
            color: #ffffff;
            transition: background-color 0.3s, color 0.3s;
        }
    
        .login-btn:hover {
            background-color: #ff4d4d;
            color: #ffffff;
        }
        
        /* Mobile menu styles */
        .mobile-menu-icon {
            display: none;
            font-size: 24px;
            cursor: pointer;
            color: #fff;
        }
        
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: -100%;
            width: 80%;
            height: 100%;
            background-color: #1f1f1f;
            z-index: 999;
            padding: 50px 30px;
            transition: left 0.3s ease;
        }
        
        .mobile-menu.active {
            left: 0;
        }
        
        .mobile-menu-close {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 24px;
            cursor: pointer;
            color: #fff;
        }
        
        .mobile-menu a {
            display: block;
            margin: 20px 0;
            font-size: 18px;
            color: #fff;
            text-decoration: none;
            transition: color 0.3s, padding-left 0.3s;
        }
        
        .mobile-menu a:hover {
            color: #ff4d4d;
            padding-left: 10px;
        }
        
        /* Responsive styles */
        @media screen and (max-width: 768px) {
            .navbar {
                padding: 15px 20px;
            }
            
            .links {
                display: none;
            }
            
            .mobile-menu-icon {
                display: block;
            }
            
            .mobile-menu {
                display: block;
            }
        }
    </style>
</head>
<body>

<!-- Navigation Bar -->
<div class="navbar">
    
    <div class="brand">
    <?php if ($user && $user['is_admin'] == 1): ?>
        <a href="https://pps.u25s1019.iedev.org/admin/dashboard">
            <strong class="brand-text">PowerPro Shop</strong>
        </a>
    <?php else: ?>
        <?= $this->Html->link(
            '<strong class="brand-text">PowerPro Shop</strong>',
            ['controller' => 'Pages', 'action' => 'display', 'home'],
            ['escape' => false]
        ) ?>
    <?php endif; ?>
</div>

    
    <div class="links">
    <?php if ($user): ?>
        <!-- Admin/Customer Navigation -->
        <?php if ($user['is_admin'] == 1): ?>
            <?= $this->Html->link('View Purchases', ['controller' => 'Purchases', 'action' => 'index', 'plugin' => false]) ?>
            <?= $this->Html->link('Add Product', ['controller' => 'Product', 'action' => 'add', 'plugin' => false]) ?>
            <?= $this->Html->link('Edit Product', ['controller' => 'Product', 'action' => 'index', 'plugin' => false]) ?>
            <?= $this->Html->link('View Contacts', ['controller' => 'ContactForm', 'action' => 'index', 'plugin' => false]) ?>
            <?= $this->Html->link('Logout', ['controller' => 'Auth', 'action' => 'logout', 'plugin' => false], ['class' => 'login-btn']) ?>
            <?= $this->Html->link(
                '<i class="fas fa-user"></i>',
                ['controller' => 'Admin', 'action' => 'dashboard'],
                ['class' => 'profile-link', 'escape' => false]
            ) ?>
        <?php else: ?>
            <!-- Customer Navigation -->
            <?= $this->Html->link('Our Products', ['controller' => 'Product', 'action' => 'index']) ?>
            <?= $this->Html->link('Our Services', ['controller' => 'Service', 'action' => 'index']) ?>
            <?= $this->Html->link('FAQ', ['controller' => 'Faq', 'action' => 'faq']) ?>
            <?= $this->Html->link('Contact Us', ['controller' => 'ContactForm', 'action' => 'add']) ?>
            <?= $this->Html->link('Logout', ['controller' => 'Auth', 'action' => 'logout'], ['class' => 'login-btn']) ?>
            <?= $this->Html->link(
                '<i class="fas fa-shopping-cart"></i>',
                ['controller' => 'Carts', 'action' => 'view'],
                ['class' => 'cart-link', 'escape' => false]
            ) ?>
        <?php endif; ?>
    <?php else: ?>
        <!-- Non-logged in User Navigation -->
        <?= $this->Html->link('Our Products', ['controller' => 'Product', 'action' => 'index']) ?>
        <?= $this->Html->link('Our Services', ['controller' => 'Service', 'action' => 'index']) ?>
        <?= $this->Html->link('FAQ', ['controller' => 'Faq', 'action' => 'faq']) ?>
        <?= $this->Html->link('Contact Us', ['controller' => 'ContactForm', 'action' => 'add']) ?>
        <?= $this->Html->link('Login', ['controller' => 'Auth', 'action' => 'login'], ['class' => 'login-btn']) ?>
        <?= $this->Html->link(
            '<i class="fas fa-shopping-cart"></i>',
            ['controller' => 'Carts', 'action' => 'view'],
            ['class' => 'cart-link', 'escape' => false]
        ) ?>
    <?php endif; ?>
    </div>
    
    <div class="mobile-menu-icon">
        <i class="fas fa-bars"></i>
    </div>
    
</div>

<!-- Mobile Menu -->
<div class="mobile-menu">
    <div class="mobile-menu-close">
        <i class="fas fa-times"></i>
    </div>
    <?php if ($user): ?>
        <!-- Admin Mobile Navigation -->
        <?php if ($user['is_admin'] == 1): ?>
            <?= $this->Html->link('View Purchases', ['controller' => 'Purchases', 'action' => 'index']) ?>
            <?= $this->Html->link('Add Product', ['controller' => 'Product', 'action' => 'add']) ?>
            <?= $this->Html->link('Edit Product', ['controller' => 'Product', 'action' => 'index']) ?> <!-- New Edit Product Link -->
            <?= $this->Html->link('View Contacts', ['controller' => 'ContactForm', 'action' => 'index']) ?>
            <?= $this->Html->link('Logout', ['controller' => 'Auth', 'action' => 'logout']) ?>
            <?= $this->Html->link(
                '<i class="fas fa-user"></i> Admin Dashboard',
                ['controller' => 'Admin', 'action' => 'dashboard'],
                ['escape' => false]
            ) ?>
        <?php else: ?>
            <!-- Customer Mobile Navigation -->
            <?= $this->Html->link('Our Products', ['controller' => 'Product', 'action' => 'index']) ?>
            <?= $this->Html->link('Our Services', ['controller' => 'Service', 'action' => 'index']) ?>
            <?= $this->Html->link('FAQ', ['controller' => 'Faq', 'action' => 'faq']) ?>
            <?= $this->Html->link('Contact Us', ['controller' => 'ContactForm', 'action' => 'add']) ?>
            <?= $this->Html->link('Logout', ['controller' => 'Auth', 'action' => 'logout']) ?>
            <?= $this->Html->link(
                '<i class="fas fa-shopping-cart"></i> View Cart',
                ['controller' => 'Carts', 'action' => 'view'],
                ['escape' => false]
            ) ?>
        <?php endif; ?>
    <?php else: ?>
        <!-- Non-logged in Mobile Navigation -->
        <?= $this->Html->link('Our Products', ['controller' => 'Product', 'action' => 'index']) ?>
        <?= $this->Html->link('Our Services', ['controller' => 'Service', 'action' => 'index']) ?>
        <?= $this->Html->link('FAQ', ['controller' => 'Faq', 'action' => 'faq']) ?>
        <?= $this->Html->link('Contact Us', ['controller' => 'ContactForm', 'action' => 'add']) ?>
        <?= $this->Html->link('Login', ['controller' => 'Auth', 'action' => 'login']) ?>
        <?= $this->Html->link(
            '<i class="fas fa-shopping-cart"></i> View Cart',
            ['controller' => 'Carts', 'action' => 'view'],
            ['escape' => false]
        ) ?>
    <?php endif; ?>
</div>


<main class="main">
    <div class="container">
        <?= $this->Flash->render() ?>
        <?= $this->fetch('content') ?>
    </div>
</main>

<footer class="footer">
    
    <div class="footer-content">
            <!-- Column 1 -->
            <div class="footer-column">
                <h3>PowerPro Shop</h3>
                <p>Your premier destination for high-quality fitness equipment and expert services to help you achieve your fitness goals.</p>
            </div>
            
            <!-- Column 2 -->
            <div class="footer-column">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>">Products</a></li>
                    <li><a href="<?= $this->Url->build(['controller' => 'Service', 'action' => 'index']) ?>">Services</a></li>
                    <li><a href="<?= $this->Url->build(['controller' => 'ContactForm', 'action' => 'add']) ?>">Contact Us</a></li>
                </ul>
            </div>
            
            <!-- Column 3 -->
            <div class="footer-column">
                <h3>Payment Methods</h3>
                <ul>
                    <li><i class="fab fa-cc-visa"></i> Visa</li>
                    <li><i class="fab fa-cc-mastercard"></i> Mastercard</li>
                    <li><i class="fab fa-cc-amex"></i> American Express</li>
                    <li><i class="fab fa-cc-paypal"></i> PayPal</li>
                </ul>
            </div>
            
            <!-- Column 4 -->
            <div class="footer-column">
                <h3>Contact Info</h3>
                <ul>
                    <li><i class="fas fa-map-marker-alt"></i> 123 Fitness Street, Melbourne, Australia</li>
                    <li><i class="fas fa-phone"></i> <a href="tel:(03) 1234 5678">(03) 1234 5678</a></li>
                    <li><i class="fas fa-envelope"></i> <a href="mailto:info@powerproshop.com">info@powerproshop.com</a></li>
                    <li><i class="fas fa-clock"></i> Mon-Fri: 9am-6pm, Sat: 10am-4pm</li>
                </ul>
            </div>
        </div>
        
        <div class="copyright">
            &copy; <?= date('Y') ?> PowerPro Shop. All Rights Reserved.
        </div>
    
</footer>

<script>
    // Mobile menu toggle
    document.querySelector('.mobile-menu-icon').addEventListener('click', function() {
        document.querySelector('.mobile-menu').classList.add('active');
    });
    
    document.querySelector('.mobile-menu-close').addEventListener('click', function() {
        document.querySelector('.mobile-menu').classList.remove('active');
    });
</script>

</body>
</html>