<?php
declare(strict_types=1);

namespace App\Controller;
use App\Model\Table\PurchasesTable;
use App\Model\Table\ProductTable;
use App\Model\Table\ContactFormTable;

class AdminController extends AppController
{
    
    protected $Product;
    protected $Purchases;
    protected $ContactForm;

    public function initialize(): void
    {
        parent::initialize();
    }
    
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);

        $user = $this->request->getSession()->read('Auth.User');
    
        if (!$user || (int)$user->is_admin !== 1) {
            $this->Flash->error('Access denied.');
            return $this->redirect('/');
        }
    }

    public function dashboard()
    {
        $this->Purchases = $this->fetchTable('Purchases');
        $this->Product = $this->fetchTable('Product');
        $this->ContactForm = $this->fetchTable('ContactForm');

        $productCount = $this->Product->find()->count();
        $purchaseCount = $this->Purchases->find()->count();
        $nonRepliedCount = $this->ContactForm->find()
        ->where(['replied' => 0])
        ->count();
        

        $this->set(compact('productCount', 'purchaseCount', 'nonRepliedCount'));
    }
    
}
