<?php
declare(strict_types=1);

namespace App\Controller;

class FaqController extends AppController
{
    public function faq()
    {
        
        $this->viewBuilder()->setLayout('default');
        
        // Get the logged-in user from the session
        $user = $this->request->getSession()->read('Auth.User');

        // FAQ data
        $faqs = [
            [
                'question' => 'How do I place an order?',
                'answer' => 'You can place an order by browsing the Our Products section and filling out the contact form.'
            ],
            [
                'question' => 'How long does delivery take?',
                'answer' => 'Delivery usually takes between 3 to 5 business days.'
            ],
            [
                'question' => 'Can I return a product?',
                'answer' => 'Yes, you can return products within 14 days if they are in original condition.'
            ],
            [
                'question' => 'Do you offer technical support?',
                'answer' => 'Yes, technical support is available through the Contact Us page.'
            ],
            [
                'question' => 'What payment methods do you accept?',
                'answer' => 'We accept all major credit and debit cards (Visa, MasterCard, AMEX), PayPal, and Afterpay for eligible purchases.'
            ],
            [
                'question' => 'Do you offer international shipping?',
                'answer' => 'Currently, we ship within Australia. International shipping to other regions is coming soon!'
            ],
            [
                'question' => 'How long does it take to process a refund?',
                'answer' => 'Refunds are typically processed within 3–5 business days after we receive your return.'
            ],
            [
                'question' => 'Can I exchange an item instead of returning it?',
                'answer' => 'Yes, exchanges are available for the same product in a different size or variation, subject to stock availability.'
            ],
        ];

        // Pass the FAQs and user data to the view
        $this->set(compact('faqs', 'user'));
    }
}
