<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Payment Entity
 *
 * @property int $id
 * @property int $purchase_id
 * @property string|null $method
 * @property string $total_price
 * @property \Cake\I18n\DateTime|null $paid_on
 * @property string|null $state
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\Purchase $purchase
 */
class Payment extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'purchase_id' => true,
        'method' => true,
        'total_price' => true,
        'paid_on' => true,
        'state' => true,
        'created' => true,
        'modified' => true,
        'purchase' => true,
    ];
}
