<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ProductPurchase Entity
 *
 * @property int $product_id
 * @property int $purchase_id
 * @property int|null $quantity
 *
 * @property \App\Model\Entity\Product $product
 * @property \App\Model\Entity\Purchase $purchase
 */
class ProductPurchase extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'quantity' => true,
        'product_id' => true,
        'purchase_id' => true,
    ];
}
