<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProductPurchase Model
 *
 * @property \App\Model\Table\PurchasesTable&\Cake\ORM\Association\BelongsTo $Purchases
 *
 * @method \App\Model\Entity\ProductPurchase newEmptyEntity()
 * @method \App\Model\Entity\ProductPurchase newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ProductPurchase> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProductPurchase get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ProductPurchase findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ProductPurchase patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ProductPurchase> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProductPurchase|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ProductPurchase saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ProductPurchase>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProductPurchase>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProductPurchase>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProductPurchase> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProductPurchase>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProductPurchase>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ProductPurchase>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ProductPurchase> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ProductPurchaseTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('product_purchase');
        $this->setDisplayField(['product_id', 'purchase_id']);
        $this->setPrimaryKey(['product_id', 'purchase_id']);

        $this->belongsTo('Product', [
            'foreignKey' => 'product_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Purchases', [
            'foreignKey' => 'purchase_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('quantity')
            ->allowEmptyString('quantity');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['product_id'], 'Product'), ['errorField' => 'product_id']);
        $rules->add($rules->existsIn(['purchase_id'], 'Purchases'), ['errorField' => 'purchase_id']);

        return $rules;
    }
}
