<?php
$this->assign('title', 'Forgot Password');
?>

<style>
    body {
        font-family: 'Montserrat', sans-serif;
        background-color: #1e1e1e;
        color: #fff;
        margin: 0;
    }

    .custom-login-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 60px 20px;
        min-height: 90vh;
    }

    .custom-login-box {
        max-width: 450px;
        width: 100%;
        background-color: #2a2a2a;
        padding: 40px;
        border-radius: 12px;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.4);
    }

    .custom-login-box h2 {
        text-align: center;
        color: #fff;
        margin-bottom: 25px;
        font-weight: 600;
        font-size: 26px;
    }

    .form-label {
        display: block;
        margin-bottom: 6px;
        font-weight: 500;
        color: #ddd;
        font-size: 15px;
    }

    input[type="email"] {
        width: 100%;
        padding: 12px 14px;
        margin-bottom: 20px;
        border: 1px solid #444;
        border-radius: 6px;
        background-color: #fff;
        color: #000;
        font-size: 15px;
    }

    .btn-login {
        width: 100%;
        padding: 14px;
        background-color: #ff4d4d;
        color: white;
        font-weight: bold;
        border: none;
        border-radius: 6px;
        font-size: 16px;
        cursor: pointer;
        transition: background-color 0.3s ease;
        text-align: center;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .btn-login:hover {
        background-color: #e84141;
    }

    .flash-message {
        text-align: center;
        color: #ff8080;
        margin-bottom: 15px;
        font-size: 14px;
    }

    @media screen and (max-width: 600px) {
        .custom-login-wrapper {
            padding: 40px 10px;
        }

        .custom-login-box {
            max-width: 95%;
            margin-left: 5%; /* slight push to the right */
            padding: 30px;
        }

        .custom-login-box h2 {
            font-size: 24px;
        }
    }
</style>

<div class="custom-login-wrapper">
    <div class="custom-login-box">
        <h2>Forgot Password</h2>

        <div class="flash-message">
            <?= $this->Flash->render() ?>
        </div>

        <?= $this->Form->create() ?>

        <label for="email" class="form-label">Enter your email</label>
        <?= $this->Form->control('email', [
            'label' => false,
            'type' => 'email',
        ]) ?>

        <?= $this->Form->button('Send Reset Link', ['class' => 'btn-login']) ?>
        <?= $this->Form->end() ?>
    </div>
</div>
