<!DOCTYPE html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= $this->Html->meta('icon') ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            margin: 0;
            font-family: 'Montserrat', sans-serif;
            color: #ffffff;
            line-height: 1.6;
            background-image: url('/img/viewcartbackground.png');
            background-size: 121%;     
            background-position: center top;
            background-repeat: no-repeat;
        }
        
        /* Navigation Bar */
        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #1f1f1f;
            padding: 20px 50px;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }

        .navbar a {
            color: #fff;
            text-decoration: none;
            margin-left: 30px;
            font-weight: 500;
            transition: color 0.3s;
        }

        .navbar a:hover {
            color: #ff4d4d;
        }

        .brand {
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 1px;
        }

        .login-btn {
            border: 1px solid #ff4d4d;
            padding: 8px 15px;
            border-radius: 4px;
            color: #ffffff;
            transition: background-color 0.3s, color 0.3s;
        }

        .login-btn:hover {
            background-color: #ff4d4d;
            color: #fff;
        }

        /* Mobile menu styles */
        .mobile-menu-icon {
            display: none;
            font-size: 24px;
            cursor: pointer;
        }
        
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: -100%;
            width: 80%;
            height: 100%;
            background-color: #1f1f1f;
            z-index: 999;
            padding: 50px 30px;
            transition: left 0.3s ease;
        }
        
        .mobile-menu.active {
            left: 0;
        }
        
        .mobile-menu-close {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 24px;
            cursor: pointer;
        }
        
        .mobile-menu a {
            display: block;
            margin: 25px 0;
            font-size: 18px;
            color: #fff;
            text-decoration: none;
            transition: color 0.3s, padding-left 0.3s;
        }
        
        .mobile-menu a:hover {
            color: #ff4d4d;
            padding-left: 10px;
        }
        
        /* Cart Page Container */
        .page-title {
            text-align: center;
            color: #ffffff !important;
            font-size: 32px;
            margin: 40px 0;
            letter-spacing: 1px;
            text-transform: uppercase;
            position: relative;
            font-weight: 700;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background-color: #ff4d4d;
        }
        
        .cart-checkout-container {
            max-width: 1200px;
            margin: 60px auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            gap: 40px;
            color: white;
        }

        .cart-left, .cart-right {
            background-color: #1a1a1a;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .cart-left {
            flex: 1.5;
        }
        
        .cart-right {
            flex: 1;
        }
        
        .section-heading {
            font-size: 24px;
            color: #ffffff !important;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 15px;
            font-weight: 600;
        }
        
        .section-heading:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 2px;
            background-color: #ff4d4d;
        }

        /* Cart Item Styling */
        .cart-item {
            display: flex;
            align-items: center;
            border-bottom: 1px solid #333;
            padding: 20px 0;
            position: relative;
        }
        
        .cart-item:last-child {
            border-bottom: none;
        }

        .item-image {
            width: 120px;
            height: 120px;
            margin-right: 25px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .item-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }
        
        .cart-item:hover .item-image img {
            transform: scale(1.05);
        }

        .item-details {
            flex: 1;
        }

        .item-details h4 {
            font-size: 20px;
            margin: 0 0 10px 0;
            font-weight: 600;
            color: #fff;
        }

        .item-details p {
            font-size: 18px;
            color: #ff4d4d;
            font-weight: 700;
            margin: 10px 0;
        }

        .item-quantity {
            margin-left: auto;
            font-size: 20px;
            background-color: #333;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            font-weight: 600;
        }
        
        .cart-actions {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }
        
        /* Cart Total Section */
        .cart-total {
            background-color: #333;
            padding: 20px;
            margin-top: 30px;
            border-radius: 8px;
            text-align: right;
            font-size: 22px;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .cart-total strong {
            color: #ff4d4d;
        }
        
        /* Express Checkout Section */
        .express-checkout {
            margin-bottom: 30px;
            background-color: #222;
            padding: 20px;
            border-radius: 8px;
        }
        
        .express-checkout p {
            font-size: 18px;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
        }

        .express-buttons {
            display: flex;
            justify-content: space-between;
            gap: 15px;
            margin-bottom: 20px;
        }

        .pay-btn {
            flex: 1;
            padding: 12px;
            background-color: #2a2a2a;
            border: 1px solid #444;
            color: white;
            font-weight: 600;
            cursor: pointer;
            border-radius: 6px;
            transition: all 0.3s ease;
        }

        .pay-btn:hover {
            background-color: #333;
            border-color: #ff4d4d;
            transform: translateY(-2px);
        }

        .separator {
            text-align: center;
            position: relative;
            margin: 20px 0;
        }
        
        .separator span {
            background-color: #222;
            padding: 0 15px;
            position: relative;
            z-index: 1;
        }
        
        .separator:before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            width: 100%;
            height: 1px;
            background-color: #444;
        }

        .card-icons {
            display: flex;
            gap: 15px;
            justify-content: center;
            align-items: center;
            margin: 20px 0;
        }
        
        .card-icons i {
            font-size: 28px;
            color: #ccc;
            transition: color 0.3s ease;
        }
        
        .card-icons i:hover {
            color: #ff4d4d;
        }

        /* Shipping Form */
        .shipping-form h4 {
            font-size: 20px;
            color: #ffffff !important;
            margin-top: 30px;
            margin-bottom: 20px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .shipping-form h4:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 30px;
            height: 2px;
            background-color: #ff4d4d;
        }
        
        .input {
            margin-bottom: 20px;
        }
        
        .input label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #ddd;
        }
        
        .input input, .input textarea {
            width: 100%;
            padding: 12px;
            background-color: #333;
            border: 1px solid #444;
            border-radius: 6px;
            color: #fff;
            font-family: 'Montserrat', sans-serif;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
            font-size: 16px;
        }
        
        .input input:focus, .input textarea:focus {
            border-color: #ff4d4d;
            outline: none;
            box-shadow: 0 0 0 2px rgba(255, 77, 77, 0.2);
            font-size: 18px;
        }

        .checkout-actions {
            display: flex;
            justify-content: space-between;
            gap: 15px;
            margin-top: 25px;
        }

        .checkout-btn, .clear-btn {
            background-color: #ff4d4d;
            color: white;
            border: none;
            padding: 25px 20px;
            font-weight: 600;
            border-radius: 6px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            text-align: center;
            transition: all 0.3s ease;
            text-decoration: none;
            display: flex;
            justify-content: center;
            align-items: center;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        
        .clear-btn {
            background-color: transparent;
            border: 2px solid #ff4d4d;
            color: #ff4d4d;
        }

        .checkout-btn:hover {
            background-color: #e53e3e;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(255, 77, 77, 0.3);
        }
        
        .clear-btn:hover {
            background-color: rgba(255, 77, 77, 0.1);
            transform: translateY(-3px);
        }
        
        /* Empty Cart Message */
        .empty-cart {
            text-align: center;
            padding: 60px 0;
        }
        
        .empty-cart i {
            font-size: 60px;
            color: #444;
            margin-bottom: 20px;
        }
        
        .empty-cart p {
            font-size: 20px;
            color: #ddd;
            margin-bottom: 30px;
        }
        
        .continue-shopping {
            background-color: #ff4d4d;
            color: white;
            padding: 24px 30px;
            font-size: 14px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 700;
            transition: all 0.3s ease;
            display: inline-block;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        
        .continue-shopping:hover {
            background-color: #e53e3e;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(255, 77, 77, 0.3);
        }
        
        /* Footer */
        .footer {
            background-color: #101010;
            padding: 70px 50px 30px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
        }
        
        .footer-column h3 {
            font-size: 20px;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 15px;
            font-weight: 600;
            color: #fff;
        }
        
        .footer-column h3:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 2px;
            background-color: #ff4d4d;
        }
        
        .footer-column p {
            color: #9e9e9e;
            line-height: 1.8;
            margin-bottom: 20px;
            font-size: 16px;
        }
        
        .footer-column ul {
            list-style: none;
            padding: 0;
            margin: 0;
            font-size: 16px;
        }
        
        .footer-column ul li {
            margin-bottom: 15px;
        }
        
        .footer-column ul li a {
            color: #9e9e9e;
            text-decoration: none;
            transition: color 0.3s, padding-left 0.3s;
            position: relative;
            font-size: 16px;
        }
        
        .footer-column ul li a:before {
            content: '›';
            position: absolute;
            left: -15px;
            opacity: 0;
            transition: opacity 0.3s, left 0.3s;
        }
        
        .footer-column ul li a:hover {
            color: #ff4d4d;
            padding-left: 15px;
        }
        
        .footer-column ul li a:hover:before {
            opacity: 1;
            left: 0;
        }
        
        .social-links {
            display: flex;
            gap: 15px;
            margin-top: 25px;
        }
        
        .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background-color: #1a1a1a;
            border-radius: 50%;
            color: #fff;
            transition: background-color 0.3s, transform 0.3s;
        }
        
        .social-link:hover {
            background-color: #ff4d4d;
            transform: translateY(-5px);
        }
        
        .copyright {
            text-align: center;
            margin-top: 50px;
            padding-top: 25px;
            border-top: 1px solid #2a2a2a;
            color: #9e9e9e;
            font-size: 14px;
        }

        
        /* Responsive adjustments */
        @media screen and (max-width: 991px) {
            body {
                background-image: none;  /* Remove background image on mobile */
            }
            .cart-checkout-container {
                flex-direction: column;
            }
            
            .cart-left, .cart-right {
                width: 100%;
            }
        }
        
        @media screen and (max-width: 768px) {
            .navbar {
                padding: 15px 20px;
            }
            
            .links {
                display: none;
            }
            
            .mobile-menu-icon {
                display: block;
            }
            
            .mobile-menu {
                display: block;
            }
            
            .page-title {
                font-size: 28px;
            }
            
            .cart-checkout-container {
                margin: 30px auto;
            }
            
            .cart-left, .cart-right {
                padding: 20px;
            }
            
            .item-image {
                width: 80px;
                height: 80px;
            }
            
            .checkout-actions {
                flex-direction: column;
            }
        }
        
        @media screen and (max-width: 480px) {
            .item-details h4 {
                font-size: 16px;
            }
            
            .item-quantity {
                font-size: 16px;
                width: 30px;
                height: 30px;
            }
        }
        
    </style>
</head>
<body>

    <!-- Flash Message -->
    <?php if ($this->Flash->render()): ?>
        <div class="flash-message">
            <?= $this->Flash->render() ?>
        </div>
    <?php endif; ?>

    <!-- Page Title -->
    <h1 class="page-title">Your Shopping Cart</h1>
    
    <!-- Cart Container -->
    <div class="cart-checkout-container">
        <div class="cart-left">
            <h3 class="section-heading">Cart Items</h3>
            
            <?php if (empty($cart)): ?>
                <div class="empty-cart">
                    <i class="fas fa-shopping-cart"></i>
                    <p>Your cart is empty.</p>
                    <a href="<?= $this->Url->build(['controller' => 'Product', 'action' => 'index']) ?>" class="continue-shopping">
                        Continue Shopping
                    </a>
                    
                </div>
            <?php else: ?>
                <?php foreach ($groupedCart as $item): ?>
                    <div class="cart-item">
                        <div class="item-image">
                            <img src="<?= h($item['image_url']) ?>" alt="<?= h($item['name']) ?>">
                        </div>
                        <div class="item-details">
                            <h4><?= h($item['name']) ?></h4>
                            <p>$<?= number_format((float)($item['price'] ?? 0), 2) ?></p>
                        </div>
                        <?php if ($item['quantity'] > 1): ?>
                            <div class="item-quantity">
                                &times;<?= $item['quantity'] ?>
                            </div>
                        <?php endif; ?>
                    
                        <!-- Remove Button -->
                        <div class="item-remove" style="margin-left: 20px;">
                            <?= $this->Form->postLink(
                                '<i class="fas fa-trash-alt"></i>',
                                ['controller' => 'Carts', 'action' => 'removeItem', $item['product_id']],
                                ['escape' => false, 'class' => 'clear-btn', 'confirm' => 'Are you sure you want to remove this item from powerproshop.com?']
                            ) ?>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <?php $total = $total ?? 0; ?>
                
                <div class="cart-total">
                    <span>TOTAL:</span>
                    <span>$<?= number_format($total, 2) ?></span>
                </div>
                
                
                <div class="cart-actions">
                    <?= $this->Html->link('CLEAR CART', ['controller' => 'Carts', 'action' => 'clear'], ['class' => 'clear-btn']) ?>
                </div>
                                
                
            <?php endif; ?>
        </div>

        <div class="cart-right">
            <h3 class="section-heading">Checkout</h3>
            
            <div class="express-checkout">
                <p>Express Checkout</p>
                <div class="express-buttons">
                    <button class="pay-btn"><i class="fab fa-apple-pay"></i> Apple Pay</button>
                    <button class="pay-btn"><i class="fab fa-paypal"></i> PayPal</button>
                </div>
                
                <div class="separator">
                    <span>OR</span>
                </div>
                
                <div class="card-icons">
                    <span>We accept:</span>
                    <i class="fab fa-cc-visa"></i>
                    <i class="fab fa-cc-mastercard"></i>
                    <i class="fab fa-cc-amex"></i>
                </div>
            </div>

                    
                <div class="checkout-actions">
                    <?= $this->Html->link(
                        'Complete Checkout',
                        ['controller' => 'Purchases', 'action' => 'add'],
                        ['class' => 'checkout-btn']
                    ) ?>
                </div>
                    


                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
    
    <script>
        // Mobile menu toggle
        document.querySelector('.mobile-menu-icon').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.add('active');
        });
        
        document.querySelector('.mobile-menu-close').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.remove('active');
        });
    </script>
    
</body>

</html>