<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContactForm $contactForm
 */

$this->assign('title', 'Contact Us');
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Contact Us</title>
    <?= $this->Html->meta('icon') ?>
    <?= $this->Html->css(['normalize.min', 'milligram.min', 'fonts']) ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            margin: 0;
            font-family: 'Montserrat', sans-serif;
            background: url('/img/products/contactbackground.png') no-repeat center center;
            background-size: cover;
            background-color: #1f1f1f;
            color: #ffffff;
            line-height: 1.6;
            font-size: 16px;
        }

        .main { padding: 60px 0; }
        .container { max-width: 1140px; margin: 0 auto; padding: 0 15px; }

        .contactForm {
            background-color: #1a1a1a;
            padding: 40px;
            border-radius: 8px;
            max-width: 700px;
            margin: 0 auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.4);
        }

        .contactForm legend {
            font-size: 28px;
            font-weight: 600;
            text-align: center;
            color: #fff;
            margin-bottom: 30px;
            position: relative;
        }

        .contactForm legend:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: #ff4d4d;
        }

        .contactForm label {
            color: #e0e0e0;
            font-weight: 500;
        }

        .contactForm input,
        .contactForm select,
        .contactForm textarea {
            background-color: #2b2b2b;
            color: #fff;
            border: 1px solid #444;
            width: 100%;
            padding: 10px 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }

        .contactForm input:focus,
        .contactForm select:focus,
        .contactForm textarea:focus {
            border-color: #ff4d4d;
            box-shadow: 0 0 8px rgba(255, 77, 77, 0.3);
            outline: none;
        }

        .contactForm button {
            background-color: #ff4d4d;
            color: white;
            padding: 20px 50px;
            border-radius: 4px;
            border: none;
            font-weight: 600;
            text-transform: uppercase;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 30px auto 10px;
            cursor: pointer;
            font-size: 16px;
            line-height: 1;
            text-align: center;
        }


        .contactForm button:hover {
            background-color: #e53e3e;
            transform: translateY(-3px);
        }

        .word-count {
            font-size: 14px;
            color: #aaa;
            text-align: right;
            margin-top: -15px;
            margin-bottom: 5px;
        }

        .warning {
            color: #ff4d4d;
        }

        .g-recaptcha {
            margin: 20px 0;
            display: flex;
            justify-content: center;
        }

        #charLimitNotice {
            font-size: 14px;
            text-align: right;
            display: none;
        }

        @media screen and (max-width: 1000px) {
            .contactForm {
                padding: 30px;
                margin: 0 auto 0 5%;
            }
        }
    </style>
</head>
<body>

<main class="main">
    <div class="container">
        <div class="row">
            <div class="column">
                <div class="contactForm form content">
                    <?= $this->Form->create($contactForm, ['url' => ['controller' => 'ContactForm', 'action' => 'add']]) ?>
                    <fieldset>
                        <legend>Leave us a message!</legend>

                        <?= $this->Form->control('first_name', [
                            'label' => 'First Name',
                            'required' => true,
                            'maxlength' => 255
                        ]) ?>

                        <?= $this->Form->control('last_name', [
                            'label' => 'Last Name',
                            'required' => true,
                            'maxlength' => 255
                        ]) ?>

                        <?= $this->Form->control('email', [
                            'label' => 'Email',
                            'type' => 'email',
                            'required' => true,
                            'maxlength' => 255
                        ]) ?>

                        <?= $this->Form->control('categories', [
                            'label' => 'Categories',
                            'type' => 'select',
                            'options' => [
                                'Installation' => 'Installation',
                                'Repair' => 'Repair',
                                'Feedback' => 'Feedback',
                                'Inquiries' => 'Inquiry',
                                'Complaints' => 'Complaint'
                            ],
                            'required' => true
                        ]) ?>

                        <?= $this->Form->control('message', [
                            'label' => 'Message',
                            'type' => 'textarea',
                            'required' => true,
                            'maxlength' => 2000,
                            'id' => 'messageField'
                        ]) ?>

                        <?= $this->Form->hidden('replied', ['value' => 0]) ?>

                        <div class="word-count" id="wordCount">Character count: 0/2000</div>
                        <div id="charLimitNotice" class="warning">You’ve reached the 2000 character limit.</div>

                        <div class="g-recaptcha" data-sitekey="6LenGxorAAAAAGNmZWr3PrIsNkuPXtVs24mHFOGt"></div>

                        <?= $this->Form->button('Submit') ?>
                    </fieldset>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    const maxChars = 2000;
    const messageField = document.getElementById('messageField');
    const wordCountElement = document.getElementById('wordCount');
    const charLimitNotice = document.getElementById('charLimitNotice');

    function updateCharCount() {
        let text = messageField.value;
        let charCount = text.length;

        if (charCount > maxChars) {
            messageField.value = text.substring(0, maxChars);
            charCount = maxChars;
        }

        wordCountElement.textContent = `Character count: ${charCount}/${maxChars}`;

        if (charCount >= maxChars) {
            wordCountElement.classList.add('warning');
            charLimitNotice.style.display = 'block';
        } else {
            wordCountElement.classList.remove('warning');
            charLimitNotice.style.display = 'none';
        }
    }

    messageField.addEventListener('input', updateCharCount);
    updateCharCount();
</script>

</body>
</html>
