<?php
$this->assign('title', 'Customer Contact Messages');
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\ContactForm> $contactForm
 */
?>
<style>
    body {
        margin: 0;
        font-family: 'Montserrat', sans-serif;
        background-color: #2b2b2b;
        color: #ffffff;
        line-height: 1.6;
    }

    .contactForm {
        padding: 40px;
        max-width: 1200px;
        margin: 0 auto;
    }

    .contactForm h1 {
        font-size: 36px;
        margin-bottom: 30px;
        position: relative;
        font-weight: 700;
        letter-spacing: 1px;
        color: #000000;
    }

    .contactForm h1:after {
        content: '';
        position: absolute;
        bottom: -10px;
        left: 0;
        width: 80px;
        height: 3px;
        background-color: #ff4d4d;
    }

    .filter-container {
        position: relative;
        display: inline-block;
        margin-bottom: 30px;
    }

    .filter-button {
        background-color: #ff4d4d;
        color: white;
        border: none;
        padding: 12px 24px;
        cursor: pointer;
        border-radius: 4px;
        font-size: 16px;
        font-weight: 600;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .filter-button:hover {
        background-color: #e53e3e;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(255, 77, 77, 0.3);
    }

    .filter-popup {
        display: none;
        position: absolute;
        background-color: #1a1a1a;
        border: 1px solid #333;
        padding: 25px;
        border-radius: 8px;
        margin-top: 10px;
        z-index: 1000;
        box-shadow: 0 10px 30px rgba(0,0,0,0.4);
        min-width: 300px;
    }

    #filter-toggle:checked ~ .filter-popup {
        display: block;
    }

    .filter-popup label {
        color: #ffffff;
        font-weight: 500;
        display: block;
        margin-bottom: 8px;
    }

    .filter-popup select {
        width: 100%;
        padding: 10px;
        margin-bottom: 15px;
        background-color: #2b2b2b;
        border: 1px solid #444;
        color: #ffffff;
        border-radius: 4px;
    }

    .filter-popup button {
        background-color: #ff4d4d;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 4px;
        cursor: pointer;
        font-weight: 600;
        transition: background-color 0.3s, transform 0.3s;
        text-transform: uppercase;
        letter-spacing: 1px;
        width: 100%;
    }

    .filter-popup button:hover {
        background-color: #e53e3e;
        transform: translateY(-2px);
    }

    .contact-entry {
        border: none;
        font-size: 14px;
        margin-bottom: 20px;
        padding: 25px;
        border-radius: 8px;
        background-color: #1a1a1a;
        transition: transform 0.3s, box-shadow 0.3s;
        position: relative;
        overflow: hidden;
    }

    .contact-entry:before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background-color: #ff4d4d;
        transform: scaleY(0);
        transform-origin: bottom;
        transition: transform 0.3s ease;
    }

    .contact-entry:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.4);
    }

    .contact-entry:hover:before {
        transform: scaleY(1);
    }

    .contact-entry p {
        margin: 10px 0;
        color: #e0e0e0;
    }

    .contact-entry strong {
        color: #ffffff;
        font-weight: 600;
    }

    .card-link {
        text-decoration: none;
        color: inherit;
        display: block;
    }

    .paginator {
        margin-top: 40px;
        text-align: center;
    }

    .pagination {
        display: flex;
        justify-content: center;
        list-style-type: none;
        padding: 0;
        margin: 0 0 20px 0;
    }

    .pagination li {
        margin: 0 5px;
    }

    .pagination li a {
        display: inline-block;
        padding: 8px 14px;
        background-color: #1a1a1a;
        color: #ffffff;
        text-decoration: none;
        border-radius: 4px;
        transition: background-color 0.3s, color 0.3s;
        font-weight: 500;
    }

    .pagination li a:hover {
        background-color: #ff4d4d;
        color: #fff;
    }

    .pagination li.active a {
        background-color: #ff4d4d;
        color: #fff;
    }

    .paginator p {
        color: #9e9e9e;
        font-size: 14px;
    }

    .status-icon {
        display: inline-block;
        width: 20px;
        height: 20px;
        margin-left: 5px;
        vertical-align: middle;
    }

    .status-true {
        color: #4cd964;
    }

    .status-false {
        color: #ff4d4d;
    }

    .category-badge {
        display: inline-block;
        padding: 5px 10px;
        background-color: #333;
        color: #fff;
        border-radius: 4px;
        font-size: 14px;
        margin-right: 5px;
        margin-top: 5px;
    }

    @media screen and (max-width: 768px) {
        .contactForm {
            padding: 20px;
        }
        
        .filter-popup {
            width: 90vw;
            left: 0;
        }
    }
</style>

<div class="contactForm index content">
    <h1>View Contact Messages</h1>
        <p style="color: #b0b0b0; font-size: 18px; margin-top: 10px; margin-bottom: 30px;">
        </p>
    <div class="filter-container">
        <input type="checkbox" id="filter-toggle" hidden>
        <label for="filter-toggle" class="filter-button">
            <i class="fas fa-filter"></i> Filter Entries
        </label>
        <div class="filter-popup">
            <?= $this->Form->create(null, ['type' => 'get']) ?>
            <?= $this->Form->control('category', [
                'label' => 'Category:',
                'type' => 'select',
                'options' => [
                    '' => 'All Categories',
                    'Installation' => 'Installation',
                    'Repair' => 'Repair',
                    'Feedback' => 'Feedback',
                    'Inquiries' => 'Inquiry',
                    'Complaints' => 'Complaints'
                ],
                'default' => $this->request->getQuery('category')
            ]) ?>
            
            <?= $this->Form->control('replied', [
                'label' => 'Reply Status:',
                'type' => 'select',
                'options' => [
                    '' => 'All Statuses',
                     1 => 'Replied',
                     0 => 'Not Replied'
                ],
                'default' => $this->request->getQuery('replied')
            ]) ?>
            
            <?= $this->Form->button('<i class="fas fa-search"></i> Apply Filter', ['escapeTitle' => false]) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
    
    <?php if (count($contactForm) > 0): ?>
        <?php foreach ($contactForm as $entry): ?>
            <?= $this->Html->link(
                '<div class="contact-entry">
                    <p><strong>Name:</strong> ' . h($entry->first_name . ' ' . $entry->last_name) . '</p>
                    <p><strong>Created:</strong> ' . h($entry->created->format('M d, Y h:i A')) . '</p>
                    <p><strong>Reply Status:</strong> ' . 
                        ($entry->replied ? 
                            '<span class="status-true"><i class="fas fa-check-circle"></i> Replied</span>' : 
                            '<span class="status-false"><i class="fas fa-times-circle"></i> Not Replied</span>') . 
                    '</p>
                    <p><strong>Category:</strong> <span class="category-badge">' . h($entry->categories) . '</span></p>
                </div>',
                ['action' => 'view', $entry->id],
                ['escape' => false, 'class' => 'card-link']
            ) ?>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="contact-entry">
            <p style="text-align: center;">No contact form entries found.</p>
        </div>
    <?php endif; ?>
    
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<i class="fas fa-angle-double-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->prev('<i class="fas fa-angle-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next('<i class="fas fa-angle-right"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->last('<i class="fas fa-angle-double-right"></i>', ['escape' => false]) ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
```