<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContactForm $contactForm
 */
?>
<style>
    * {
        font-size: 1vw;
        color: black;
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .title {
        font-size: 2vw;
        font-weight: bold;
        margin-bottom: 20px;
    }

    .contactForm {
        background: #fff;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        margin: 20px;
        overflow: hidden;
    }

    table {
        width: 100%;
        margin-bottom: 20px;
        border-collapse: collapse;
    }

    table th, table td {
        padding: 10px;
        border: 1px solid #ddd;
        text-align: left;
        word-break: break-word;
    }

    .text {
        margin-top: 20px;
    }

    blockquote {
        background-color: #f9f9f9;
        padding: 15px;
        border-left: 5px solid #007bff;
        margin: 15px 0;
        font-style: italic;
        word-wrap: break-word;
        overflow-wrap: break-word;
        overflow-x: auto;
        max-width: 100%;
        white-space: pre-wrap;
    }

    .row {
        display: flex;
        justify-content: center;
        padding: 20px;
    }

    .column {
        width: 80%;
    }

    .form-actions {
        margin-top: 20px;
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        align-items: center;
    }

    .btn {
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: bold;
        cursor: pointer;
        text-align: center;
        text-decoration: none;
        font-size: 1.1em;
        border: none;
    }

    .btn-update {
        background-color: #007bff;
        color: white;
    }

    .btn-update:hover {
        background-color: #0056b3;
    }

    .btn-delete {
        background-color: #dc3545;
        color: white;
    }

    .btn-delete:hover {
        background-color: #c82333;
    }

    .btn-reply {
        background-color: #28a745;
        color: white;
        margin-left: auto;
    }

    .btn-reply:hover {
        background-color: #218838;
    }

    .replied-label {
        font-size: 1.1em;
        font-weight: normal;
        margin-right: 8px;
    }

    input[type="checkbox"] {
        transform: scale(1.2);
        margin-right: 8px;
    }

    .btn-back {
        background-color: #ff4d4d;
        color: white;
        text-decoration: none;
        padding: 10px 16px;
        border-radius: 5px;
        font-weight: bold;
        transition: background-color 0.3s ease, transform 0.3s ease;
    }

    .btn-back:hover {
        background-color: #e53e3e;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(255, 77, 77, 0.3);
    }
</style>

<div class="row">
    <div class="column column-80">
        <div style="margin: 20px;">
            <?= $this->Html->link('<i class="fas fa-arrow-left"></i> Back to Messages', ['action' => 'index'], [
                'escape' => false,
                'class' => 'btn btn-back'
            ]) ?>
        </div>
        <div class="contactForm view content">
            <h3 class="title"><?= __('Enquiry no.') . h($contactForm->id) ?></h3>

            <table>
                <tr><th><?= __('First Name') ?></th><td><?= h($contactForm->first_name) ?></td></tr>
                <tr><th><?= __('Last Name') ?></th><td><?= h($contactForm->last_name) ?></td></tr>
                <tr><th><?= __('Email') ?></th><td><?= h($contactForm->email) ?></td></tr>
                <tr><th><?= __('Categories') ?></th><td><?= h($contactForm->categories) ?></td></tr>
                <tr><th><?= __('Created') ?></th><td><?= h($contactForm->created) ?></td></tr>
                <tr><th><?= __('Replied') ?></th>
                    <td>
                        <?= $contactForm->replied
                            ? '<i class="fas fa-check-circle" style="color:green;"></i>'
                            : '<i class="fas fa-times-circle" style="color:red;"></i>'; ?>
                    </td>
                </tr>
            </table>

            <div class="text">
                <strong><?= __('Message') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($contactForm->message)); ?>
                </blockquote>
            </div>

            <div class="form-actions">
                <div style="display: flex; gap: 10px;">
                    <!-- Update Replied Form -->
                    <?= $this->Form->create($contactForm, ['url' => ['action' => 'toggleReplied', $contactForm->id]]) ?>
                        <label class="replied-label">
                            <?= $this->Form->checkbox('replied', [
                                'checked' => $contactForm->replied ? true : false,
                                'value' => 1
                            ]) ?>
                            <?= __('Replied') ?>
                        </label>
                        <?= $this->Form->button(__('Update'), ['class' => 'btn btn-update']) ?>
                    <?= $this->Form->end() ?>

                    <!-- Delete Button -->
                    <?= $this->Form->postLink(
                        __('Delete'),
                        ['action' => 'delete', $contactForm->id],
                        [
                            'confirm' => __('Are you sure you want to delete # {0}?', $contactForm->id),
                            'class' => 'btn btn-delete'
                        ]
                    ) ?>
                </div>

                <!-- Reply Button Right-Aligned -->
                <a href="https://mail.google.com/mail/?view=cm&to=<?= h($contactForm->email) ?>&su=Reply%20to%20Your%20Enquiry&body=Hi%20<?= h($contactForm->first_name) ?>%2C%0A%0AThank%20you%20for%20your%20message." target="_blank" class="btn btn-reply">
                    <i class="fas fa-reply"></i> <?= __('Reply') ?>
                </a>
            </div>
        </div>
    </div>
</div>
