<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */

// Get the current logged-in user from the session
$user = $this->request->getSession()->read('Auth.User');

// If the user is not an admin, show the modal popup
if (empty($user) || $user['is_admin'] != 1): ?>
    <script>
        window.onload = function() {
            document.getElementById('adminModal').style.display = 'block';
        };

        function closeModal() {
            document.getElementById('adminModal').style.display = 'none';
            window.location.href = '/';
        }
    </script>

    <!-- Modal Popup for non-admin users -->
    <div id="adminModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); z-index: 9999; color: white; padding-top: 100px; text-align: center;">
        <div style="background: #333; padding: 30px; border-radius: 10px; width: 50%; margin: 0 auto; box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.5);">
            <h2 style="font-size: 30px; color: #ff4d4d;">Admins Only</h2>
            <p style="font-size: 18px; color: #fff;">You do not have permission to access this page.</p>
            <button onclick="closeModal()" style="padding: 15px 25px; font-size: 18px; background-color: #ff4d4d; border: none; color: white; cursor: pointer; border-radius: 5px; box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.3);">Close</button>
        </div>
    </div>
<?php else: ?>

    <head>
        <?= $this->Html->charset() ?>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Add Product</title>
        <?= $this->Html->meta('icon') ?>
        <?= $this->Html->css(['normalize.min', 'milligram.min', 'fonts']) ?>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>

        <style>
            body {
                margin: 0;
                font-family: 'Montserrat', sans-serif;
                background-color: #121212;
                color: #e0e0e0;
                line-height: 1.6;
                font-size: 16px;
            }

            .main { padding: 60px 0; }
            
            .container {
                max-width: 1140px;
                margin: 0 auto;
                padding: 0 15px;
                margin-left: 20%;
            }

            .product.form.content {
                background: rgba(0, 0, 0, 0.85);
                border-radius: 10px;
                padding: 40px;
                width: 100%;
                max-width: 800px;
                margin: 0 auto;
                box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.4);
            }

            .product.form.content legend {
                font-size: 28px;
                color: #ff4d4d;
                text-align: center;
                margin-bottom: 30px;
                font-weight: 700;
            }

            .product.form.content input,
            .product.form.content textarea,
            .product.form.content select {
                width: 100%;
                padding: 14px;
                margin: 12px 0;
                border-radius: 5px;
                border: 1px solid #333;
                font-size: 16px;
                background-color: #2a2a2a;
                color: #fff;
                transition: border-color 0.3s, box-shadow 0.3s;
            }

            .product.form.content input:focus,
            .product.form.content textarea:focus,
            .product.form.content select:focus {
                border-color: #ff4d4d;
                box-shadow: 0 0 6px rgba(255, 77, 77, 0.4);
                outline: none;
            }

            .product.form.content button {
                background-color: #ff4d4d;
                color: white;
                font-size: 18px;
                padding: 25px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                width: 100%;
                margin-top: 20px;
                box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.3);
                display: flex;
                justify-content: center;
                align-items: center;
            }

            .product.form.content button:hover {
                background-color: #ff6666;
            }

            .product.form.content label {
                font-size: 18px;
                margin-bottom: 8px;
                display: block;
                color: #fff;
            }

            @media (max-width: 768px) {
                .product.form.content {
                    width: 130%;
                    margin-left: auto;
                    margin-right: auto;
                }

                .container {
                    margin-left: 0;
                    padding: 0 15px;
                }
            }
        </style>
    </head>

    <div class="row">
        <div class="column column-80">
            <div class="product form content">
                <?= $this->Form->create($product, ['type' => 'file']) ?>
                <fieldset>
                    <legend><?= __('Add Product') ?></legend>
                    <?= $this->Form->control('name', ['label' => 'Product Name']) ?>
                    <?= $this->Form->control('description', ['label' => 'Description']) ?>
                    <?= $this->Form->control('image_file', ['type' => 'file', 'label' => 'Image (JPG/PNG)']) ?>
                    <?= $this->Form->control('price', ['label' => 'Price']) ?>
                    <?= $this->Form->control('stock', ['label' => 'Stock Quantity', 'type' => 'number', 'value' => 0]) ?>
                </fieldset>

                <!-- Submit Button -->
                <?= $this->Form->button(__('Add Product')) ?>
                <?= $this->Form->end() ?>
            </div>
        </div>
    </div>
<?php endif; ?>
