<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>PowerPro Shop - Our Products</title>
    <?= $this->Html->meta('icon') ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>

<?php
function renderStars($rating) {
    $output = '<div class="star-rating">';
    $rounded = round((float) ($rating ?? 0) * 2) / 2; // round to nearest 0.5

    for ($i = 1; $i <= 5; $i++) {
        if ($rounded >= $i) {
            $output .= '<i class="fas fa-star" style="color: #ccc;"></i>'; // full star
        } elseif ($rounded == ($i - 0.5)) {
            $output .= '<i class="fas fa-star-half-alt" style="color: #ccc;"></i>'; // half star
        } else {
            $output .= '<i class="far fa-star" style="color: #ccc;"></i>'; // empty star
        }
    }

    $output .= ' <span style="color: #888;">(' . number_format((float) ($rating ?? 0), 1) . ')</span>';
    $output .= '</div>';
    return $output;
}
?>

<style>
    * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
    }

    .service.index.content {
        background-color: transparent !important;
    }
    

    body, .body {
        background-color: #121212;
        color: #ffffff !important;
    }

    .product-container {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 40px;
        padding: 50px 20px;
        max-width: 1200px;
        margin: 0 auto;
    }

    .product-card {
        background-color: #1e1e1e;
        border-radius: 5px;
        overflow: hidden;
        text-align: left;
        padding: 20px;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }

    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(255, 165, 0, 0.2);
        cursor: pointer;
    }

    .product-card img {
        width: 100%;
        height: 180px;
        object-fit: cover;
        margin-bottom: 15px;
        background-color: #ddd;
        border-radius: 4px;
    }

    .product-card p {
        margin: 10px 0;
        font-size: 1.6rem;
        font-weight: 500;
        color: #f5f5f5;
    }

    .product-card p:nth-child(3) {
        font-size: 1.2rem;
        color: #cccccc;
    }

    .product-card form {
        margin-top: auto;
    }

    .product-card button {
        background-color: transparent;
        border: 1px solid #ff4d4d;
        color: #ff4d4d;
        padding: 10px 0;
        margin-top: 15px;
        width: 100%;
        text-transform: uppercase;
        font-weight: bold;
        font-size: 0.9rem;
        transition: background-color 0.3s, color 0.3s;
    }

    .product-card button:hover {
        background-color: #ff4d4d;
        color: #1e1e1e;
    }

    .paginator {
        text-align: center;
        margin: 40px 0;
        color: #fff;
    }

    .pagination {
        display: inline-block;
        padding-left: 0;
        margin: 0;
        border-radius: 4px;
    }

    .pagination li {
        display: inline;
        margin: 0 4px;
    }

    .pagination li a, .pagination li span {
        color: #ff4d4d;
        padding: 6px 12px;
        text-decoration: none;
        transition: background 0.3s;
        border-radius: 4px;
    }

    .pagination li a:hover {
        background: #ff4d4d;
        color: #1e1e1e;
    }
</style>

<div class="service index content">

    <div class="product-container">
        <?php foreach ($product as $entry): ?>
            <div class="product-card">
                <?= $this->Html->link(
                    '<img src="' . h($entry->image_url) . '" alt="' . h($entry->name) . '">
                    <p>' . h($entry->name) . '</p>
                    <p>$' . h(number_format($entry->price, 2)) . '</p>',
                    ['action' => 'view', $entry->id],
                    ['escape' => false]
                ) ?>
                
                <?php
                    $stock = (int)$entry->stock;
                    if ($stock > 10) {
                        $stockStatus = '<div class="stock-status" style="background-color: #28a745; color: white; padding: 4px 8px; border-radius: 5px; font-size: 0.9rem; display: inline-block;">In Stock</div>';
                    } elseif ($stock > 0) {
                        $stockStatus = '<div class="stock-status" style="background-color: orange; color: white; padding: 4px 8px; border-radius: 5px; font-size: 0.9rem; display: inline-block;">Low Stock</div>';
                    } else {
                        $stockStatus = '<div class="stock-status" style="background-color: #dc3545; color: white; padding: 4px 8px; border-radius: 5px; font-size: 0.9rem; display: inline-block;">Out of Stock</div>';
                    }

                    echo $stockStatus;
                ?>
                
                <br>

                <!-- Add to Cart or Edit Button based on admin status -->
                <?php
                    $user = $this->request->getSession()->read('Auth.User');
                    if (!empty($user) && !empty($user->is_admin)) {
                        // If admin, show 'Edit' button instead of 'Add to Cart'
                        echo $this->Html->link(
                            'Edit',
                            ['controller' => 'Product', 'action' => 'edit', $entry->id],
                            ['class' => 'form-button edit-button']
                        );
                    } else {
                        // Regular customer: show 'Add to Cart' button
                        echo $this->Form->create(null, ['url' => ['controller' => 'Carts', 'action' => 'add']]);
                        echo $this->Form->hidden('product_id', ['value' => $entry->id]);
                        echo $this->Form->hidden('name', ['value' => $entry->name]);
                        echo $this->Form->hidden('price', ['value' => $entry->price]);
                        echo renderStars($entry->rating);

                        $cleanImageUrl = $entry->image_url;
                        if (strpos($cleanImageUrl, 'public_html') !== false) {
                            $cleanImageUrl = str_replace('public_html', '', $cleanImageUrl);
                        }
                        echo $this->Form->hidden('image_url', ['value' => $cleanImageUrl]);
                        echo $this->Form->button('Add to Cart');
                        echo $this->Form->end();
                    }
                ?>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>

</div>
