<?php
function renderStars($rating, $productId) {
    $output = '<div class="star-rating">';
    $rounded = round($rating * 2) / 2;

    for ($i = 1; $i <= 5; $i++) {
        if ($rounded >= $i) {
            $output .= '<i class="fas fa-star" style="color: #ccc;"></i>';
        } elseif ($rounded == ($i - 0.5)) {
            $output .= '<i class="fas fa-star-half-alt" style="color: #ccc;"></i>';
        } else {
            $output .= '<i class="far fa-star" style="color: #ccc;"></i>';
        }
    }

    $productId = (string) $productId; // Ensure not null
    $url = \Cake\Routing\Router::url(['controller' => 'Ratings', 'action' => 'index', $productId]);

    $output .= ' <span style="color: #888;">(' . number_format($rating, 1) . ')</span>';

    $output .= '</div>';

    return $output;
}
?>

<style>
    body {
        margin: 0;
        padding: 0;
        background-color: #121212;
        color: #ffffff;
    }

    .product-page {
        display: flex;
        flex-wrap: wrap;
        gap: 40px;
        max-width: 1200px;
        padding: 20px;
        margin: 0 auto;
        align-items: flex-start;
    }

    .product-image, .product-details {
        flex: 1 1 45%;
        min-width: 300px;
    }

    .product-image {
        background-color: #d3d3d3;
        aspect-ratio: 4 / 3;
        max-height: 400px;
        width: 100%;
        overflow: hidden;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }

    .product-details {
        display: flex;
        flex-direction: column;
        gap: 20px;
        flex: 1 1 45%;
        min-width: 300px;
    }
    


    .stock-status {
        background-color: #06402b;
        color: #fff;
        border-radius: 5px;
        font-weight: bold;
        font-size: 15px;
        padding: 10px;
        text-align: center;
    }
    
    .product-name {
        font-size: 35px;
        color: #cccccc;
        font-weight: bold;
        line-height: 1;
        margin-top: 20px;
    }
    
    .product-description-wrapper {
        max-width: 60ch;
    }

    .product-description {
        display: -webkit-box;
        -webkit-line-clamp: 4;  /* default to 4 lines */
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: normal;
        word-wrap: break-word;
        overflow-wrap: break-word;
        line-height: 1.6;
        transition: all 0.3s ease;
        color: #cccccc;
    }

    .product-description.expanded {
        -webkit-line-clamp: unset;
        overflow: visible;
    }

    .toggle-button {
        background: none;
        color: #ff4d4d;
        border: none;
        font-weight: bold;
        margin-top: 5px;
        cursor: pointer;
        font-size: 14px;
        padding: 0;
    }

    .product-price {
        font-size: 2rem;
        font-weight: bold;
    }

    .quantity-container {
        display: flex;
        flex-direction: column;
        gap: 5px;
        max-width: 75px;
    }

    .quantity-label {
        font-weight: bold;
    }

    .quantity-input {
        width: 100%;
        height: 40px;
        text-align: center;
        border: 1px solid #ccc;
        background: transparent;
        color: #fff;
        font-size: 16px;
    }

    .add-to-cart-btn {
        margin-top: 20px;
        width: 100%;
        background: transparent;
        border: 2px solid #ff4d4d;
        color: #ff4d4d;
        font-size: 18px;
        font-weight: bold;
        text-transform: uppercase;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .add-to-cart-btn:hover {
        background-color: #ff4d4d;
        color: #121212;
    }
    
    .review-title {
        margin-bottom: 20px;
        color: white;
    }
    
    .star {
        cursor: pointer;
        color: gray;
        font-size: 32px;
    }
    
    .star.selected {
        color: gold;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .product-page {
            flex-direction: column;
            gap: 30px;
            padding: 20px 10px;
        }

        .product-image, .product-details {
            flex: 1 1 100%;
            max-width: 100%;
        }

        .product-image {
            height: 300px;
        }

        .product-details h1 {
            font-size: 2rem;
        }

        .product-price {
            font-size: 1.8rem;
        }
    }
</style>

<div class="product-page">
    <div class="product-image">
        <?php if (!empty($product->image_url)): ?>
            <img src="<?= $this->Url->build(h($product->image_url)) ?>" alt="<?= h($product->name) ?>">
        <?php else: ?>
            <div style="width: 100%; height: 100%; background: #ccc;"></div>
        <?php endif; ?>
    </div>

    <div class="product-details">
        <div class="product-name"><?= h($product->name) ?></div>

        <?= renderStars($product->rating, $product->id) ?>

        <?php if ((int)$product->stock > 10): ?>
            <div class="stock-status" style="background-color: #28a745; color: white; padding: 5px 10px; border-radius: 5px;">
                In Stock
            </div>
        <?php elseif ((int)$product->stock > 0): ?>
            <div class="stock-status" style="background-color: orange; color: white; padding: 5px 10px; border-radius: 5px;">
                Low Stock
            </div>
        <?php else: ?>
            <div class="stock-status" style="background-color: #dc3545; color: white; padding: 5px 10px; border-radius: 5px;">
                Out of Stock
            </div>
        <?php endif; ?>

    <div class="product-description-wrapper">
        <div class="product-description" id="product-description">
            <?= h($product->description) ?>
        </div>
        <button id="toggle-button" class="toggle-button">Read more ▼</button>
    </div>

        <div class="product-price">$<?= number_format($product->price, 2) ?></div>
        
        <?= $this->Form->create(null, ['url' => ['controller' => 'Carts', 'action' => 'add']]) ?>
            <?= $this->Form->hidden('product_id', ['value' => $product->id]) ?>
            <?= $this->Form->hidden('name', ['value' => $product->name]) ?>
            <?= $this->Form->hidden('price', ['value' => $product->price]) ?>

            <?php
                $cleanImageUrl = $product->image_url;
                if (strpos($cleanImageUrl, 'public_html') !== false) {
                    $cleanImageUrl = str_replace('public_html', '', $cleanImageUrl);
                }
            ?>
                <?= $this->Form->hidden('image_url', ['value' => $cleanImageUrl]) ?>

                <div class="quantity-container">
                    <label class="quantity-label" for="quantity">Quantity</label>
                    <input class="quantity-input" type="number" name="quantity" id="quantity" min="1" value="1">
                </div>

                <button type="submit" class="add-to-cart-btn">Add to Cart</button>
        <?= $this->Form->end() ?>

    </div>
</div>

<div class="rating-form-container">
    <h3 style="color: white;">Leave a Rating!</h3>
    <?= $this->Form->create(null, ['url' => ['controller' => 'Ratings', 'action' => 'add']]) ?>
        <?= $this->Form->hidden('product_id', ['value' => $product->id]) ?>

        <div id="star-container" style="font-size: 24px;">
            <?php for ($i = 1; $i <= 5; $i++): ?>
                <span class="star" data-value="<?= $i ?>">☆</span>
            <?php endfor; ?>
        </div>

        <?= $this->Form->hidden('rating', ['id' => 'rating-value']) ?>

        <?= $this->Form->control('review', [
            'label' => 'Your review',
            'type' => 'textarea',
            'rows' => 3,
            'class' => 'form-control'
        ]) ?>

        <?= $this->Form->button(__('Submit Rating'), ['class' => 'btn btn-primary mt-2']) ?>
    <?= $this->Form->end() ?>
</div>

<div style="max-width: 1200px; margin: 10px auto; padding: 10 px;">
    
    <h2 class="review-title">Customer Reviews</h2>

    <?php if (empty($product->ratings)): ?>
            <p style="color: #aaa;">No reviews yet.</p>
    <?php else: ?>
        <?php foreach ($product->ratings as $rating): ?>
            <div style="margin-bottom: 20px; padding: 15px; background: #1e1e1e; border-radius: 5px;">
                <p><strong>Rating:</strong> <?= h($rating->rating) ?> / 5</p>
                <?php if (!empty($rating->review)): ?>
                    <p><strong>Review:</strong> <?= h($rating->review) ?></p>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const stars = document.querySelectorAll(".star");
    const ratingInput = document.getElementById("rating-value");

    stars.forEach(star => {
        star.addEventListener("click", () => {
            const value = star.getAttribute("data-value");
            ratingInput.value = value;

            stars.forEach(s => {
                s.classList.toggle("selected", s.getAttribute("data-value") <= value);
            });
        });
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const desc = document.getElementById("product-description");
    const toggle = document.getElementById("toggle-button");

    const checkOverflow = () => {
        const clone = desc.cloneNode(true);
        clone.style.display = 'block';
        clone.style.position = 'absolute';
        clone.style.visibility = 'hidden';
        clone.style.webkitLineClamp = 'unset';
        clone.classList.add('expanded'); // simulate expanded
        document.body.appendChild(clone);

        const fullHeight = clone.scrollHeight;
        const visibleHeight = desc.scrollHeight;

        document.body.removeChild(clone);

        if (fullHeight > visibleHeight + 5) {
            toggle.style.display = 'inline-block';
        }
    };

    checkOverflow();

    // Toggle expanded view
    toggle.addEventListener("click", function () {
        desc.classList.toggle("expanded");

        if (desc.classList.contains("expanded")) {
            toggle.textContent = "Read less ▲";
        } else {
            toggle.textContent = "Read more ▼";
        }
    });
});
</script>
    
    
