<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Purchase $purchase
 */

// Get the current logged-in user from the session
$user = $this->request->getSession()->read('Auth.User');
?>

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700;800&display=swap" rel="stylesheet">

<?php if (empty($user) || $user['is_admin'] != 1): ?>
    <script>
        window.onload = function() {
            document.getElementById('adminModal').style.display = 'block';
        };

        function closeModal() {
            document.getElementById('adminModal').style.display = 'none';
            window.location.href = '/';
        }
    </script>

    <!-- Modal Popup for non-admin users -->
    <div id="adminModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); z-index: 9999; color: white; padding-top: 100px; text-align: center;">
        <div style="background: #333; padding: 30px; border-radius: 10px; width: 50%; margin: 0 auto; box-shadow: 0 0 15px rgba(0,0,0,0.5);">
            <h2 style="font-size: 30px; color: #ff4d4d;">Admins Only</h2>
            <p style="font-size: 18px;">You do not have permission to access this page.</p>
            <button onclick="closeModal()" style="padding: 15px 25px; font-size: 18px; background-color: #ff4d4d; border: none; color: white; cursor: pointer; border-radius: 5px;">Close</button>
        </div>
    </div>
<?php else: ?>
    <!-- Admin Form -->
    <div class="purchase-edit-section" style="padding: 60px 50px; background-color: #121212; min-height: 70vh; font-family: 'Montserrat', sans-serif; color: #fff;">

    <div class="back-button-wrapper">
        <?= $this->Html->link('← Back', ['controller' => 'Purchases', 'action' => 'index'], ['class' => 'back-button']) ?>
    </div>


        <h1 style="font-size: 48px; font-weight: 800; text-align: center; margin-bottom: 30px; color: #ff4d4d;">
            Edit Purchase
            <span style="display: block; width: 100px; height: 4px; background: #ff4d4d; margin: 10px auto 0;"></span>
        </h1>

        <div style="max-width: 700px; margin: 0 auto; background: #1f1f1f; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.3);">
            <?= $this->Form->create($purchase) ?>

            <div class="form-grid">
                <?= $this->Form->control('first_name', ['label' => 'First Name', 'class' => 'form-control']) ?>
                <?= $this->Form->control('last_name', ['label' => 'Last Name', 'class' => 'form-control']) ?>
                <?= $this->Form->control('email', ['label' => 'Email', 'class' => 'form-control']) ?>
                <?= $this->Form->control('phone_number', ['label' => 'Phone Number', 'class' => 'form-control']) ?>
                <?= $this->Form->control('address_line1', ['label' => 'Address Line 1', 'class' => 'form-control']) ?>
                <?= $this->Form->control('address_line2', ['label' => 'Address Line 2', 'class' => 'form-control']) ?>
                <?= $this->Form->control('suburb', ['label' => 'Suburb', 'class' => 'form-control']) ?>
                <?= $this->Form->control('state', ['label' => 'State', 'class' => 'form-control']) ?>
                <?= $this->Form->control('postcode', ['label' => 'Postcode', 'class' => 'form-control']) ?>
                <?= $this->Form->control('purchase_date', ['empty' => true, 'label' => 'Purchase Date', 'class' => 'form-control']) ?>
                <?= $this->Form->control('total_price', ['label' => 'Total Price', 'class' => 'form-control']) ?>
                <?= $this->Form->control('status', [
                    'label' => 'Order Status',
                    'class' => 'form-control large-select',
                    'type' => 'select',
                    'options' => ['Paid' => 'Paid', 'Pending' => 'Pending', 'Cancelled' => 'Cancelled'],
                    'empty' => 'Pending'
                ]) ?>

            </div>

            <div style="margin-top: 30px;">
                <?= $this->Form->button(__('Submit'), ['class' => 'form-button']) ?>
            </div>

            <?= $this->Form->end() ?>
        </div>
    </div>
<?php endif; ?>

<style>
    .form-control {
        background-color: #333;
        color: white;
        border: 1px solid #444;
        border-radius: 5px;
        padding: 12px;
        margin-bottom: 20px;
        font-size: 15px;
        width: 100%;
    }
    
    .large-select {
        height: 44px;
        font-size: 16px;
        padding: 10px 12px;
    }


    .form-control:focus {
        outline: none;
        border-color: #ff4d4d;
        box-shadow: 0 0 6px rgba(255, 77, 77, 0.6);
    }

    label {
        font-weight: 600;
        margin-bottom: 6px;
        display: block;
        color: #fff;
    }

    .form-button {
        background-color: #ff4d4d;
        color: white;
        padding: 10px;
        border: none;
        border-radius: 5px;
        font-weight: bold;
        font-size: 16px;
        cursor: pointer;
        width: 100%;
        transition: background-color 0.3s;
    }

    .form-button:hover {
        background-color: #ff3333;
    }

    .form-grid {
        display: grid;
        grid-template-columns: 1fr;
        gap: 15px;
    }
    
    .back-button-wrapper {
        text-align: left;
        margin-bottom: 20px;
    }
    
    .back-button {
        background-color: transparent;
        color: #ff4d4d;
        font-weight: bold;
        text-decoration: none;
        font-size: 16px;
        border: 2px solid #ff4d4d;
        padding: 8px 14px;
        border-radius: 5px;
        transition: background-color 0.3s, color 0.3s;
    }
    
    .back-button:hover {
        background-color: #ff4d4d;
        color: white;
    }


    @media (min-width: 768px) {
        .form-grid {
            grid-template-columns: 1fr 1fr;
        }
    }
</style>
