<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Purchase $purchase
 */
?>

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700;800&display=swap" rel="stylesheet">

<div class="purchase-view-section" style="padding: 60px 50px; background-color: #121212; min-height: 70vh; font-family: 'Montserrat', sans-serif; color: #fff;">

    <!-- Back Button -->
    <div class="back-button-wrapper">
        <?= $this->Html->link('← Back', ['controller' => 'Purchases', 'action' => 'index'], ['class' => 'back-button']) ?>
    </div>

    <h1 style="font-size: 34px; font-weight: 800; text-align: center; margin-bottom: 30px; color: #ff4d4d;">
        <?= h($purchase->first_name . ' ' . $purchase->last_name) ?>'s Order
        <span style="display: block; width: 100px; height: 4px; background: #ff4d4d; margin: 10px auto 0;"></span>
    </h1>

    <!-- Product Purchases -->
    <div class="section-block">
        <h2 class="section-title">Products Ordered</h2>
        <?php if (!empty($purchase->product_purchase)) : ?>
        <div class="table-responsive">
            <table class="styled-table">
                <thead>
                    <tr>
                        <th>Product</th>
                        <th>Quantity</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($purchase->product_purchase as $productPurchase) : ?>
                    <tr>
                        <td><?= h($productPurchase->product->name ?? 'N/A') ?></td>
                        <td><?= h($productPurchase->quantity) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
            <p style="color: #ccc;">No products found for this order.</p>
        <?php endif; ?>
    </div>

    <!-- Order Details -->
    <div class="section-block">
        <h2 class="section-title">Order Details</h2>
        <table class="styled-table">
            <tbody>
                <tr><th>Name</th><td><?= h($purchase->first_name . ' ' . $purchase->last_name) ?></td></tr>
                <tr><th>Email</th><td><?= h($purchase->email) ?></td></tr>
                <tr><th>Phone Number</th><td><?= h($purchase->phone_number) ?></td></tr>
                <tr><th>Address Line 1</th><td><?= h($purchase->address_line1) ?></td></tr>
                <tr><th>Address Line 2</th><td><?= h($purchase->address_line2) ?></td></tr>
                <tr><th>Suburb</th><td><?= h($purchase->suburb) ?></td></tr>
                <tr><th>State</th><td><?= h($purchase->state) ?></td></tr>
                <tr><th>Postcode</th><td><?= h($purchase->postcode) ?></td></tr>
                <tr><th>Status</th><td><?= h($purchase->status) ?></td></tr>
                <tr><th>Total Price</th><td>$<?= $this->Number->format($purchase->total_price) ?></td></tr>
                <tr><th>Purchase Date</th><td><?= h($purchase->purchase_date) ?></td></tr>
            </tbody>
        </table>
    </div>

    <!-- Related Payments -->
    <div class="section-block">
        <h2 class="section-title">Payments</h2>
        <?php if (!empty($purchase->payments)) : ?>
        <div class="table-responsive">
            <table class="styled-table">
                <thead>
                    <tr>
                        <th>Method</th>
                        <th>Total Price</th>
                        <th>Paid On</th>
                        <th>State</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($purchase->payments as $payment) : ?>
                    <tr>
                        <td><?= h($payment->method) ?></td>
                        <td>$<?= $this->Number->format($payment->total_price) ?></td>
                        <td><?= h($payment->paid_on) ?></td>
                        <td><?= h($payment->state) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
            <p style="color: #ccc;">No payment information available.</p>
        <?php endif; ?>
    </div>
</div>

<style>
    .back-button-wrapper {
        text-align: left;
        margin-bottom: 20px;
    }

    .back-button {
        display: inline-block;
        font-size: 14px;
        padding: 6px 14px;
        border: 2px solid #ff4d4d;
        background: transparent;
        color: #ff4d4d;
        border-radius: 4px;
        text-decoration: none;
        font-weight: 600;
        transition: background-color 0.3s, color 0.3s;
    }

    .back-button:hover {
        background-color: #ff4d4d;
        color: white;
    }

    .section-block {
        margin-top: 40px;
    }

    .section-title {
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 20px;
        color: #fff;
        border-left: 6px solid #ff4d4d;
        padding-left: 16px;
    }

    .styled-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    .styled-table th,
    .styled-table td {
        padding: 12px 20px;
        border: 1px solid #333;
    }

    .styled-table th {
        background-color: #333;
        color: #fff;
        text-align: left;
    }

    .styled-table td {
        background-color: #444;
        color: #fff;
    }

    .styled-table tr:hover td {
        background-color: #2a2a2a;
    }

    .table-responsive {
        overflow-x: auto;
    }
</style>
