<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Our Services - PowerPro Shop</title>
    <link href="/favicon.ico" type="image/x-icon" rel="icon">
    <link href="/favicon.ico" type="image/x-icon" rel="shortcut icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body {
            margin: 0;
            font-family: 'Montserrat', sans-serif;
            background-color: #2b2b2b;
            color: #ffffff;
            line-height: 1.6;
            overflow-x: hidden; /* Prevent horizontal scroll */
        }
    
        
        /* Mobile menu styles */
        .mobile-menu-icon {
            display: none;
            font-size: 24px;
            cursor: pointer;
        }
        
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: -100%;
            width: 80%;
            height: 100%;
            background-color: #1f1f1f;
            z-index: 999;
            padding: 50px 30px;
            transition: left 0.3s ease;
        }
        
        .mobile-menu.active {
            left: 0;
        }
        
        .mobile-menu-close {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 24px;
            cursor: pointer;
        }
        
        .mobile-menu a {
            display: block;
            margin: 20px 0;
            font-size: 18px;
        }
        
        /* Services section styles */
        .page-header {
            background-color: #1a1a1a;
            padding: 50px 0;
            text-align: center;
            margin-bottom: 60px;
        }
        
        .page-header h1 {
            font-size: 40px;
            color: white;
            margin: 0;
            position: relative;
            display: inline-block;
            padding-bottom: 15px;
        }
        
        .page-header h1:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background-color: #ff4d4d;
        }
        
        .services-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px 60px;
        }
        
        .section-title {
            font-size: 32px;
            color: white;
            margin-bottom: 40px;
            text-align: center;
            position: relative;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: #ff4d4d;
        }
        
        .services-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(500px, 1fr));
            gap: 30px;
        }
        
        .service-card {
            background-color: #1a1a1a;
            border-radius: 8px;
            overflow: hidden;
            transition: transform 0.3s, box-shadow 0.3s;
            text-decoration: none;
            display: block;
        }
        
        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.3);
        }
        
        .service-image {
            height: 350px;
            overflow: hidden;
        }
        
        .service-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .service-card:hover .service-image img {
            transform: scale(1.05);
        }
        
        .service-info {
            padding: 25px;
            text-align: center;
        }
        
        .service-name {
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 15px;
            color: #ffffff;
        }
        
        .service-description {
            font-size: 16px;
            color: #dddddd;
            margin-bottom: 20px;
        }
        
        .learn-more-btn {
            background-color: transparent;
            border: 2px solid #ff4d4d;
            color: #ff4d4d;
            padding: 8px 20px;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .learn-more-btn:hover {
            background-color: #ff4d4d;
            color: #fff;
        }
        
        /* Footer */
        .footer {
            background-color: #101010;
            padding: 70px 50px 30px;
            width: 100%; /* Ensure it spans full width */
            position: relative;
            left: 0;
            right: 0;
            margin: 0; /* Ensure no margin causing issues */
        }
        
        /* Footer content container */
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            width: 100%; /* Full width */
            margin: 0; /* Remove margin if any */
            padding: 0; /* No extra padding */
        }
        
        /* Footer column styles */
        .footer-column h3 {
            font-size: 20px;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 15px;
            font-weight: 600;
            color: #fff;
        }
        
        .footer-column h3:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 2px;
            background-color: #ff4d4d;
        }
        
        .footer-column p {
            color: #9e9e9e;
            line-height: 1.8;
            margin-bottom: 20px;
            font-size: 16px;
        }
        
        .footer-column ul {
            list-style: none;
            padding: 0;
            margin: 0;
            font-size: 16px;
        }
        
        .footer-column ul li {
            margin-bottom: 15px;
        }
        
        .footer-column ul li a {
            color: #9e9e9e;
            text-decoration: none;
            transition: color 0.3s, padding-left 0.3s;
            position: relative;
            font-size: 16px;
        }
        
        .footer-column ul li a:before {
            content: '›';
            position: absolute;
            left: -15px;
            opacity: 0;
            transition: opacity 0.3s, left 0.3s;
        }
        
        .footer-column ul li a:hover {
            color: #ff4d4d;
            padding-left: 15px;
        }
        
        .footer-column ul li a:hover:before {
            opacity: 1;
            left: 0;
        }
        
        /* Social links */
        .social-links {
            display: flex;
            gap: 15px;
            margin-top: 25px;
        }
        
        .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background-color: #1a1a1a;
            border-radius: 50%;
            color: #fff;
            transition: background-color 0.3s, transform 0.3s;
        }
        
        .social-link:hover {
            background-color: #ff4d4d;
            transform: translateY(-5px);
        }
        
        /* Copyright */
        .copyright {
            text-align: center;
            margin-top: 50px;
            padding-top: 25px;
            border-top: 1px solid #2a2a2a;
            color: #9e9e9e;
            font-size: 14px;
        }

        
        /* Responsive adjustments */
        @media screen and (max-width: 768px) {
            .navbar {
                padding: 20px;
            }
            
            .links {
                display: none;
            }
            
            .mobile-menu-icon {
                display: block;
            }
            
            .mobile-menu {
                display: block;
            }
            
            .services-grid {
                grid-template-columns: 1fr;
            }
            
            .service-image {
                height: 220px;
            }
            
            .page-header {
                padding: 30px 0;
            }
            
            .page-header h1 {
                font-size: 32px;
            }
        }
    </style>
</head>
<body>
    
    <!-- Mobile Menu -->
    <div class="mobile-menu">
        <div class="mobile-menu-close">
            <i class="fas fa-times"></i>
        </div>
        <a href="/product">Our Products</a>
        <a href="/service">Our Services</a>
        <a href="/faq/faq">FAQ</a>
        <a href="/contact-form/add">Contact Us</a>
        <a href="/auth/login">Login</a>
    </div>
    
    <!-- Page Header -->
    <div class="page-header">
        <h1>Our Services</h1>
    </div>
    
    <!-- Services Section -->
    <div class="services-container">
        <h2 class="section-title">Premium Support For Your Fitness Journey</h2>
        
        <div class="services-grid">
            <!-- Installation Service -->
            <a href="/service/view/1" class="service-card">
                <div class="service-image">
                    <img src="img/services/service1.jpg" alt="Installation">
                </div>
                <div class="service-info">
                    <h3 class="service-name">Installation</h3>
                    <p class="service-description">Our Installation Service is for our prestige and premium customers. Our certified technicians ensure your equipment is properly set up for optimal performance and safety.</p>
                    <span class="learn-more-btn">Learn More</span>
                </div>
            </a>
            
            <!-- Repair Service -->
            <a href="/service/view/3" class="service-card">
                <div class="service-image">
                    <img src="img/services/service2.jpg" alt="Repair">
                </div>
                <div class="service-info">
                    <h3 class="service-name">Repair</h3>
                    <p class="service-description">Got a problem with your product? Send out your repair form here, and we will dispatch our brilliant technicians to help you get back to your fitness routine!</p>
                    <span class="learn-more-btn">Learn More</span>
                </div>
            </a>
        </div>
    </div>
    
    

    <script>
        // Mobile menu toggle
        document.querySelector('.mobile-menu-icon').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.add('active');
        });
        
        document.querySelector('.mobile-menu-close').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.remove('active');
        });
    </script>
</body>
</html>
