<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Service $service
 */
?>

<div class="service view content" style="color: #d0d0d0; max-width: 800px; margin: 60px auto; padding: 40px 30px; border-radius: 12px; background-color: #1a1a1a; box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2); font-family: 'Montserrat', sans-serif;">

    <h2 style="text-align: center; margin-bottom: 30px; font-size: 32px; color: #fff; position: relative;">
        <?= h($service->name) ?>
        <span style="display: block; margin: 10px auto 0; width: 80px; height: 3px; background-color: #ff4d4d;"></span>
    </h2>

    <?php if (!empty($service->image_url)): ?>
        <div style="text-align: center; margin-bottom: 30px;">
            <img src="<?= $this->Url->build('/' . h($service->image_url), ['fullBase' => true]) ?>" 
                 alt="<?= h($service->name) ?>"  
                 style="max-width: 60%; height: auto; border-radius: 10px; border: 1px solid #333;">
        </div>
    <?php endif; ?>

    <div style="margin-bottom: 50px; font-size: 20px; line-height: 1.9; color: #e0e0e0; text-align: center;">
        <?php if (strtolower($service->name) === 'installation'): ?>
            Our professional installation service is designed exclusively for our premium customers, ensuring seamless setup and top-tier support — discover the difference today.
        <?php else: ?>
            <?= nl2br(h($service->description)) ?>
        <?php endif; ?>
    </div>

    <div style="text-align: center;">
        <p style="margin-bottom: 30px; font-size: 22px; font-weight: 600; color: #ffffff;">
            If you’re interested in this service and would like a quote, please fill out our contact form.
        </p>
        <a href="<?= $this->Url->build(['controller' => 'ContactForm', 'action' => 'add']) ?>" target="_blank"
           style="display: inline-block; margin-top: 10px; background-color: #ff4d4d; color: white; padding: 20px 40px; font-size: 20px; border-radius: 8px; text-decoration: none; font-weight: 700; transition: background-color 0.3s;">
            Request a Quote
        </a>
    </div>

</div>
