<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
?>
<style>
    .users.form.content {
        background-color: #fff;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        max-width: 600px;
        margin: 50px auto;
    }

    .users.form.content legend {
        font-size: 24px;
        margin-bottom: 20px;
        color: #333;
    }

    .users.form.content label {
        font-size: 16px;
        color: #333;
    }

    .users.form.content input[type="text"],
    .users.form.content input[type="email"],
    .users.form.content input[type="password"] {
        width: 100%;
        padding: 12px;
        margin: 10px 0;
        border: 1px solid #ddd;
        border-radius: 5px;
        box-sizing: border-box;
        font-size: 16px;
    }

    .users.form.content input[type="text"]:focus,
    .users.form.content input[type="email"]:focus,
    .users.form.content input[type="password"]:focus {
        border-color: #007bff;
        outline: none;
    }

    .users.form.content .submit-button {
        background-color: #dc3545;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 6px;
        font-weight: bold;
        cursor: pointer;
        font-size: 16px;
        width: 100%;
    }

    .users.form.content .submit-button:hover {
        background-color: #c82333;
    }
</style>

<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $user->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $user->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Users'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="users form content">
            <?= $this->Form->create($user) ?>
            <fieldset>
                <legend><?= __('Edit User') ?></legend>
                <!-- Removed nonce and nonce_expiry fields -->
                <?php
                    echo $this->Form->control('email', ['label' => 'Email', 'required' => true]);
                    
                    // If the password is being edited, display the unhashed password
                    // By default, CakePHP does not show passwords in plain text in forms
                    echo $this->Form->control('password', ['label' => 'Password', 'required' => false, 'placeholder' => 'Enter a new password']);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit'), ['class' => 'submit-button']) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
