<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
?>
<style>
    .user-details {
        background-color: #fff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        max-width: 600px;
        margin: 30px auto;
    }

    .user-details h3 {
        color: #333;
        font-size: 24px;
        margin-bottom: 20px;
    }

    .user-details table {
        width: 100%;
        border-collapse: collapse;
    }

    .user-details th, .user-details td {
        padding: 12px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }

    .user-details th {
        background-color: #f4f4f4;
        color: #555;
    }

    .user-details tr:hover {
        background-color: #f9f9f9;
    }
</style>

<div class="user-details">
    <h3><?= h($user->email) ?></h3>
    <table>
        <tr>
            <th><?= __('ID') ?></th>
            <td><?= $this->Number->format($user->id) ?></td>
        </tr>
        <tr>
            <th><?= __('Created') ?></th>
            <td><?= $this->Time->format($user->created, 'dd/MM/yyyy hh:mm:ss a') ?></td>
        </tr>
        <tr>
            <th><?= __('Modified') ?></th>
            <td><?= $this->Time->format($user->modified, 'dd/MM/yyyy hh:mm:ss a') ?></td>
        </tr>
    </table>
</div>
